/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap;

import io.quarkus.test.bootstrap.ExtensionBootstrap;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.inject.KubectlClient;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.scenarios.KubernetesScenario;
import io.quarkus.test.utils.FileUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;

public class KubernetesExtensionBootstrap
implements ExtensionBootstrap {
    public static final String CLIENT = "kubectl-client";
    private static final PropertyLookup DELETE_NAMESPACE_AFTER = new PropertyLookup("ts.kubernetes.delete.namespace.after.all", Boolean.TRUE.toString());
    private KubectlClient client;

    public boolean appliesFor(ExtensionContext context) {
        return context.getRequiredTestClass().isAnnotationPresent(KubernetesScenario.class);
    }

    public void beforeAll(ExtensionContext context) {
        this.client = KubectlClient.create();
    }

    public void afterAll(ExtensionContext context) {
        if (DELETE_NAMESPACE_AFTER.getAsBoolean().booleanValue()) {
            this.client.deleteNamespace();
        }
    }

    public void updateServiceContext(ServiceContext context) {
        context.put(CLIENT, (Object)this.client);
    }

    public Optional<Object> getParameter(Class<?> clazz) {
        if (clazz == KubectlClient.class) {
            return Optional.of(this.client);
        }
        return Optional.empty();
    }

    public void onError(ExtensionContext context, Throwable throwable) {
        Map<String, String> logs = this.client.logs();
        for (Map.Entry<String, String> podLog : logs.entrySet()) {
            FileUtils.copyContentTo((String)podLog.getValue(), (Path)Paths.get("target/logs", podLog.getKey() + ".log"));
        }
    }
}

