/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.inject.KubectlClient;
import io.quarkus.test.logging.KubernetesLoggingHandler;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.services.quarkus.ProdQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.QuarkusManagedResource;
import io.quarkus.test.services.quarkus.model.LaunchMode;
import io.quarkus.test.utils.DockerUtils;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public class KubernetesQuarkusApplicationManagedResource
extends QuarkusManagedResource {
    private static final String DEPLOYMENT_SERVICE_PROPERTY = "kubernetes.service";
    private static final String DEPLOYMENT_TEMPLATE_PROPERTY = "kubernetes.template";
    private static final String QUARKUS_KUBERNETES_TEMPLATE = "/quarkus-app-kubernetes-template.yml";
    private static final String DEPLOYMENT = "kubernetes.yml";
    private final ProdQuarkusApplicationManagedResourceBuilder model;
    private final KubectlClient client;
    private LoggingHandler loggingHandler;
    private boolean init;
    private boolean running;
    private String image;

    public KubernetesQuarkusApplicationManagedResource(ProdQuarkusApplicationManagedResourceBuilder model) {
        this.model = model;
        this.client = (KubectlClient)model.getContext().get("kubectl-client");
    }

    public void start() {
        if (this.running) {
            return;
        }
        if (!this.init) {
            this.image = this.createImageAndPush();
            this.init = true;
        }
        this.loadDeployment();
        this.client.scaleTo(this.model.getContext().getOwner(), 1);
        this.running = true;
        this.loggingHandler = new KubernetesLoggingHandler(this.model.getContext());
        this.loggingHandler.startWatching();
    }

    public void stop() {
        if (this.loggingHandler != null) {
            this.loggingHandler.stopWatching();
        }
        this.client.scaleTo(this.model.getContext().getOwner(), 0);
        this.running = false;
    }

    public String getHost(Protocol protocol) {
        this.validateProtocol(protocol);
        return this.client.url(this.model.getContext().getOwner());
    }

    public int getPort(Protocol protocol) {
        this.validateProtocol(protocol);
        return this.client.port(this.model.getContext().getOwner());
    }

    public List<String> logs() {
        return this.loggingHandler.logs();
    }

    public void restart() {
        this.stop();
        if (this.model.containsBuildProperties()) {
            this.init = false;
            this.model.build();
        }
        this.start();
    }

    protected LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    private void validateProtocol(Protocol protocol) {
        if (protocol == Protocol.HTTPS) {
            Assertions.fail((String)"SSL is not supported for Kubernetes tests yet");
        } else if (protocol == Protocol.GRPC) {
            Assertions.fail((String)"gRPC is not supported for Kubernetes tests yet");
        }
    }

    private String createImageAndPush() {
        return DockerUtils.createImageAndPush((ServiceContext)this.model.getContext(), (LaunchMode)this.model.getLaunchMode(), (Path)this.model.getArtifact());
    }

    private void loadDeployment() {
        String deploymentFile = this.model.getContext().getOwner().getConfiguration().getOrDefault(DEPLOYMENT_TEMPLATE_PROPERTY, QUARKUS_KUBERNETES_TEMPLATE);
        this.client.applyServiceProperties(this.model.getContext().getOwner(), deploymentFile, this::replaceDeploymentContent, this.model.getContext().getServiceFolder().resolve(DEPLOYMENT));
    }

    private String replaceDeploymentContent(String content) {
        String customServiceName = this.model.getContext().getOwner().getConfiguration().get(DEPLOYMENT_SERVICE_PROPERTY);
        if (StringUtils.isNotEmpty((CharSequence)customServiceName)) {
            content = content.replaceAll(Pattern.quote(customServiceName), this.model.getContext().getName());
        }
        return content.replaceAll(Pattern.quote("${IMAGE}"), this.image).replaceAll(Pattern.quote("${SERVICE_NAME}"), this.model.getContext().getName()).replaceAll(Pattern.quote("${ARTIFACT}"), this.model.getArtifact().getFileName().toString()).replaceAll(Pattern.quote("${INTERNAL_PORT}"), this.model.getContext().getOwner().getProperty("quarkus.http.port", "8080"));
    }
}

