/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.inject.KubectlClient;
import io.quarkus.test.logging.KubernetesLoggingHandler;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.services.quarkus.QuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.QuarkusManagedResource;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.List;
import org.junit.jupiter.api.Assertions;

public abstract class KubernetesQuarkusApplicationManagedResource<T extends QuarkusApplicationManagedResourceBuilder>
extends QuarkusManagedResource {
    protected final T model;
    protected final KubectlClient client;
    private LoggingHandler loggingHandler;
    private boolean init;
    private boolean running;

    public KubernetesQuarkusApplicationManagedResource(T model) {
        super(model.getContext());
        this.model = model;
        this.client = (KubectlClient)model.getContext().get("kubectl-client");
    }

    protected abstract void doInit();

    protected abstract void doUpdate();

    public void start() {
        if (this.running) {
            return;
        }
        if (!this.init) {
            this.doInit();
            this.init = true;
        } else {
            this.doUpdate();
        }
        this.client.scaleTo(this.model.getContext().getOwner(), 1);
        this.running = true;
        this.loggingHandler = new KubernetesLoggingHandler(this.model.getContext());
        this.loggingHandler.startWatching();
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        if (this.loggingHandler != null) {
            this.loggingHandler.stopWatching();
        }
        this.client.scaleTo(this.model.getContext().getOwner(), 0);
        this.running = false;
    }

    public String getHost(Protocol protocol) {
        this.validateProtocol(protocol);
        return this.client.url(this.model.getContext().getOwner());
    }

    public int getPort(Protocol protocol) {
        this.validateProtocol(protocol);
        return this.client.port(this.model.getContext().getOwner());
    }

    public boolean isRunning() {
        if (!this.running) {
            return false;
        }
        return super.isRunning() && this.routeIsReachable(Protocol.HTTP);
    }

    public List<String> logs() {
        return this.loggingHandler.logs();
    }

    public void restart() {
        this.stop();
        if (this.model.containsBuildProperties()) {
            this.init = false;
            this.model.build();
        }
        this.start();
    }

    protected LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    private void validateProtocol(Protocol protocol) {
        if (protocol == Protocol.HTTPS) {
            Assertions.fail((String)"SSL is not supported for Kubernetes tests yet");
        } else if (protocol == Protocol.GRPC) {
            Assertions.fail((String)"gRPC is not supported for Kubernetes tests yet");
        }
    }

    private boolean routeIsReachable(Protocol protocol) {
        return ((Response)RestAssured.given().baseUri(this.getHost(protocol)).basePath("/").port(this.getPort(protocol)).get()).getStatusCode() != 503;
    }
}

