/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap;

import io.quarkus.test.bootstrap.ExtensionBootstrap;
import io.quarkus.test.bootstrap.ScenarioContext;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.inject.KubectlClient;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.logging.Log;
import io.quarkus.test.scenarios.KubernetesScenario;
import io.quarkus.test.utils.FileUtils;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

public class KubernetesExtensionBootstrap
implements ExtensionBootstrap {
    public static final String CLIENT = "kubectl-client";
    private static final PropertyLookup DELETE_NAMESPACE_AFTER = new PropertyLookup("ts.kubernetes.delete.namespace.after.all", Boolean.TRUE.toString());
    private KubectlClient client;

    public boolean appliesFor(ScenarioContext context) {
        boolean isValidConfig = context.isAnnotationPresent(KubernetesScenario.class);
        if (isValidConfig && !DELETE_NAMESPACE_AFTER.getAsBoolean().booleanValue() && KubectlClient.ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean().booleanValue()) {
            Log.error((String)"-Dts.kubernetes.delete.project.after.all=false is only supported with -Dts.kubernetes.ephemeral.namespaces.enabled=false", (Object[])new Object[0]);
            isValidConfig = false;
        }
        return isValidConfig;
    }

    public void beforeAll(ScenarioContext context) {
        context.setDebug(DELETE_NAMESPACE_AFTER.getAsBoolean() == false && KubectlClient.ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean() == false);
        this.client = KubectlClient.create(context.getId());
    }

    public void afterAll(ScenarioContext context) {
        if (DELETE_NAMESPACE_AFTER.getAsBoolean().booleanValue()) {
            this.client.deleteNamespace();
        }
    }

    public void updateServiceContext(ServiceContext context) {
        context.put(CLIENT, (Object)this.client);
    }

    public Optional<Object> getParameter(Class<?> clazz) {
        if (clazz == KubectlClient.class) {
            return Optional.of(this.client);
        }
        return Optional.empty();
    }

    public void onError(ScenarioContext context, Throwable throwable) {
        Map<String, String> logs = this.client.logs();
        for (Map.Entry<String, String> podLog : logs.entrySet()) {
            FileUtils.copyContentTo((String)podLog.getValue(), (Path)this.logsTestFolder(context).resolve(podLog.getKey() + ".log"));
        }
    }

    private Path logsTestFolder(ScenarioContext context) {
        return context.getLogFolder().resolve(context.getRunningTestClassName());
    }
}

