/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.services.quarkus.ArtifactQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.KubernetesQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.model.LaunchMode;
import io.quarkus.test.utils.DockerUtils;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ContainerRegistryKubernetesQuarkusApplicationManagedResource
extends KubernetesQuarkusApplicationManagedResource<ArtifactQuarkusApplicationManagedResourceBuilder> {
    private static final String DEPLOYMENT_SERVICE_PROPERTY = "kubernetes.service";
    private static final String DEPLOYMENT_TEMPLATE_PROPERTY = "kubernetes.template";
    private static final String QUARKUS_KUBERNETES_TEMPLATE = "/quarkus-app-kubernetes-template.yml";
    private static final String DEPLOYMENT = "kubernetes.yml";
    private String image;

    public ContainerRegistryKubernetesQuarkusApplicationManagedResource(ArtifactQuarkusApplicationManagedResourceBuilder model) {
        super(model);
    }

    @Override
    protected void doInit() {
        this.image = this.createImageAndPush();
        this.loadDeployment();
    }

    @Override
    protected void doUpdate() {
        this.loadDeployment();
    }

    protected Map<String, String> addExtraTemplateProperties() {
        return Collections.emptyMap();
    }

    private String createImageAndPush() {
        return DockerUtils.createImageAndPush((ServiceContext)((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext(), (LaunchMode)this.getLaunchMode(), (Path)((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getArtifact());
    }

    private void loadDeployment() {
        String deploymentFile = ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getConfiguration().getOrDefault(DEPLOYMENT_TEMPLATE_PROPERTY, QUARKUS_KUBERNETES_TEMPLATE);
        this.client.applyServiceProperties(((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner(), deploymentFile, this::replaceDeploymentContent, this.addExtraTemplateProperties(), ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getServiceFolder().resolve(DEPLOYMENT));
    }

    private String replaceDeploymentContent(String content) {
        String customServiceName = ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getConfiguration().get(DEPLOYMENT_SERVICE_PROPERTY);
        if (StringUtils.isNotEmpty((CharSequence)customServiceName)) {
            content = content.replaceAll(Pattern.quote(customServiceName), ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getName());
        }
        return content.replaceAll(Pattern.quote("${IMAGE}"), this.image).replaceAll(Pattern.quote("${SERVICE_NAME}"), ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getName()).replaceAll(Pattern.quote("${ARTIFACT}"), ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getArtifact().getFileName().toString()).replaceAll(Pattern.quote("${INTERNAL_PORT}"), ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getProperty("quarkus.http.port", "8080"));
    }
}

