/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.services.quarkus.KubernetesQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.ProdQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.utils.Command;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.MavenUtils;
import io.quarkus.test.utils.PropertiesUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public class ExtensionKubernetesQuarkusApplicationManagedResource
extends KubernetesQuarkusApplicationManagedResource<ProdQuarkusApplicationManagedResourceBuilder> {
    private static final String USING_EXTENSION_PROFILE = "-Pdeploy-to-kubernetes-using-extension";
    private static final String QUARKUS_PLUGIN_DEPLOY = "-Dquarkus.kubernetes.deploy=true";
    private static final String QUARKUS_PLUGIN_INGRESS_EXPOSE = "-Dquarkus.kubernetes.ingress.expose=true";
    private static final String QUARKUS_CONTAINER_NAME = "quarkus.application.name";
    private static final String QUARKUS_CONTAINER_IMAGE_REGISTRY = "quarkus.container-image.registry";
    private static final String QUARKUS_CONTAINER_IMAGE_GROUP = "quarkus.container-image.group";
    private static final String QUARKUS_KUBERNETES_CLIENT_NAMESPACE = "quarkus.kubernetes-client.namespace";
    private static final String QUARKUS_KUBERNETES_CLIENT_TRUST_CERTS = "quarkus.kubernetes-client.trust-certs";
    private static final String QUARKUS_KUBERNETES_ENV_VARS = "quarkus.kubernetes.env.vars.";
    private static final String QUARKUS_KUBERNETES_LABELS = "quarkus.kubernetes.labels.";
    private static final Path RESOURCES_FOLDER = Paths.get("src", "main", "resources", "application.properties");

    public ExtensionKubernetesQuarkusApplicationManagedResource(ProdQuarkusApplicationManagedResourceBuilder model) {
        super(model);
    }

    @Override
    protected void doInit() {
        this.cloneProjectToServiceAppFolder();
        this.copyBuildPropertiesIntoAppFolder();
        this.deployProjectUsingMavenCommand();
    }

    @Override
    protected void doUpdate() {
        this.client.applyServicePropertiesUsingDeploymentConfig(((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner());
    }

    public boolean needsBuildArtifact() {
        return false;
    }

    public void validate() {
        super.validate();
        if (((ProdQuarkusApplicationManagedResourceBuilder)this.model).requiresCustomBuild()) {
            Assertions.fail((String)"Custom source classes or forced dependencies is not supported by `UsingKubernetesExtension`");
        }
    }

    protected void withAdditionalArguments(List<String> args) {
    }

    private void copyBuildPropertiesIntoAppFolder() {
        Map buildProperties = ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getBuildProperties();
        if (buildProperties.isEmpty()) {
            return;
        }
        Path applicationPropertiesPath = ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getComputedApplicationProperties();
        if (Files.exists(applicationPropertiesPath, new LinkOption[0])) {
            buildProperties.putAll(PropertiesUtils.toMap((Path)applicationPropertiesPath));
        }
        PropertiesUtils.fromMap((Map)buildProperties, (Path)this.getContext().getServiceFolder().resolve(RESOURCES_FOLDER));
        ((ProdQuarkusApplicationManagedResourceBuilder)this.model).createSnapshotOfBuildProperties();
    }

    private void deployProjectUsingMavenCommand() {
        MavenUtils.installParentPomsIfNeeded();
        String namespace = this.client.namespace();
        List args = MavenUtils.mvnCommand((ServiceContext)((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext());
        args.addAll(Arrays.asList(USING_EXTENSION_PROFILE, "-B", "-V", "package", QUARKUS_PLUGIN_DEPLOY, QUARKUS_PLUGIN_INGRESS_EXPOSE, "-DskipTests=true", "-DskipITs=true", "-Dcheckstyle.skip", "-Dquarkus.build.skip=false"));
        this.propagateContainerRegistryIfSet(args);
        args.add(this.withContainerName());
        args.add(this.withKubernetesClientNamespace(namespace));
        args.add(this.withKubernetesClientTrustCerts());
        args.add(this.withLabelsForWatching());
        args.add(this.withLabelsForScenarioId());
        this.withEnvVars(args, ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getProperties());
        this.withAdditionalArguments(args);
        try {
            new Command(args).onDirectory(((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getServiceFolder()).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to run maven command. Caused by " + e.getMessage()));
        }
    }

    private void propagateContainerRegistryIfSet(List<String> args) {
        String containerRegistry = System.getProperty("ts.container.registry-url");
        if (StringUtils.isNotEmpty((CharSequence)containerRegistry)) {
            int lastSlash = containerRegistry.lastIndexOf("/");
            String registryHost = containerRegistry.substring(0, lastSlash);
            String registryGroup = containerRegistry.substring(lastSlash + 1);
            args.add(MavenUtils.withProperty((String)QUARKUS_CONTAINER_IMAGE_REGISTRY, (String)registryHost));
            args.add(MavenUtils.withProperty((String)QUARKUS_CONTAINER_IMAGE_GROUP, (String)registryGroup));
        }
    }

    private String withLabelsForWatching() {
        return this.withLabels("tsLogWatch", ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getName());
    }

    private String withLabelsForScenarioId() {
        return this.withLabels("scenarioId", this.client.getScenarioId());
    }

    private String withLabels(String label, String value) {
        return MavenUtils.withProperty((String)(QUARKUS_KUBERNETES_LABELS + label), (String)value);
    }

    private String withContainerName() {
        return MavenUtils.withProperty((String)QUARKUS_CONTAINER_NAME, (String)((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getName());
    }

    private String withKubernetesClientNamespace(String namespace) {
        return MavenUtils.withProperty((String)QUARKUS_KUBERNETES_CLIENT_NAMESPACE, (String)namespace);
    }

    private String withKubernetesClientTrustCerts() {
        return MavenUtils.withProperty((String)QUARKUS_KUBERNETES_CLIENT_TRUST_CERTS, (String)Boolean.TRUE.toString());
    }

    private void withEnvVars(List<String> args, Map<String, String> envVars) {
        for (Map.Entry<String, String> envVar : envVars.entrySet()) {
            String envVarKey = envVar.getKey().replaceAll(Pattern.quote("."), "-");
            args.add(MavenUtils.withProperty((String)(QUARKUS_KUBERNETES_ENV_VARS + envVarKey), (String)envVar.getValue()));
        }
    }

    private void cloneProjectToServiceAppFolder() {
        FileUtils.copyCurrentDirectoryTo((Path)((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getServiceFolder());
    }
}

