/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap.inject;

import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import io.fabric8.kubernetes.client.impl.KubernetesClientImpl;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.logging.Log;
import io.quarkus.test.model.CustomVolume;
import io.quarkus.test.utils.Command;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.PropertiesUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public final class KubectlClient {
    public static final String LABEL_TO_WATCH_FOR_LOGS = "tsLogWatch";
    public static final String LABEL_SCENARIO_ID = "scenarioId";
    public static final PropertyLookup ENABLED_EPHEMERAL_NAMESPACES = new PropertyLookup("ts.kubernetes.ephemeral.namespaces.enabled", Boolean.TRUE.toString());
    private static final String RESOURCE_MNT_FOLDER = "/resource";
    private static final int NAMESPACE_NAME_SIZE = 10;
    private static final int NAMESPACE_CREATION_RETRIES = 5;
    private static final int DEPLOYMENT_CREATION_TIMEOUT = 30;
    private static final String KUBECTL = "kubectl";
    private static final int HTTP_PORT_DEFAULT = 80;
    private final String currentNamespace;
    private final KubernetesClientImpl client;
    private final String scenarioId;

    private KubectlClient(String scenarioUniqueName) {
        this.scenarioId = scenarioUniqueName;
        if (ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean().booleanValue()) {
            this.currentNamespace = this.createNamespace();
            Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withTrustCerts(true)).withNamespace(this.currentNamespace)).build();
            this.client = KubectlClient.createClient(config);
        } else {
            Config config = ((ConfigBuilder)new ConfigBuilder().withTrustCerts(true)).build();
            this.client = KubectlClient.createClient(config);
            this.currentNamespace = this.client.getNamespace();
        }
        this.setCurrentSessionNamespace(this.currentNamespace);
    }

    private static KubernetesClientImpl createClient(Config config) {
        return (KubernetesClientImpl)new KubernetesClientBuilder().withConfig(config).build().adapt(KubernetesClientImpl.class);
    }

    public static KubectlClient create(String scenarioName) {
        return new KubectlClient(scenarioName);
    }

    public String namespace() {
        return this.currentNamespace;
    }

    public void apply(Service service, Path file) {
        try {
            new Command(new String[]{KUBECTL, "apply", "-f", file.toAbsolutePath().toString(), "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to apply resource " + file.toAbsolutePath().toString() + " for " + service.getName() + ". Caused by " + e.getMessage()));
        }
    }

    public void applyServicePropertiesUsingDeploymentConfig(Service service) {
        Deployment deployment = (Deployment)((RollableScalableResource)this.client.apps().deployments().withName(service.getName())).get();
        Map<String, String> enrichProperties = this.enrichProperties(service.getProperties(), deployment);
        deployment.getSpec().getTemplate().getSpec().getContainers().forEach(container -> enrichProperties.entrySet().forEach(envVar -> container.getEnv().add(new EnvVar((String)envVar.getKey(), (String)envVar.getValue(), null))));
        this.client.apps().deployments().withTimeout(30L, TimeUnit.SECONDS).delete();
        ((RollableScalableResource)this.client.apps().deployments().resource((Object)deployment)).create();
    }

    public void applyServiceProperties(Service service, String file, UnaryOperator<String> update, Path target) {
        this.applyServiceProperties(service, file, update, Collections.emptyMap(), target);
    }

    public void applyServiceProperties(Service service, String file, UnaryOperator<String> update, Map<String, String> extraTemplateProperties, Path target) {
        String content = FileUtils.loadFile((String)file);
        content = this.enrichTemplate(service, (String)update.apply(content), extraTemplateProperties);
        this.apply(service, FileUtils.copyContentTo((String)content, (Path)target));
    }

    public void expose(Service service, Integer port) {
        try {
            new Command(new String[]{KUBECTL, "expose", "deployment", service.getName(), "--port=" + port, "--name=" + service.getName(), "--type=NodePort", "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Service failed to be exposed. Caused by " + e.getMessage()));
        }
    }

    public void scaleTo(Service service, int replicas) {
        try {
            new Command(new String[]{KUBECTL, "scale", "deployment/" + service.getName(), "--replicas=" + replicas, "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Service failed to be scaled. Caused by " + e.getMessage()));
        }
    }

    public List<Pod> podsInService(Service service) {
        return ((PodList)((FilterWatchListDeletable)this.client.pods().withLabel(LABEL_TO_WATCH_FOR_LOGS, service.getName())).list()).getItems();
    }

    public Map<String, String> logs() {
        HashMap<String, String> logs = new HashMap<String, String>();
        for (Pod pod : ((PodList)this.client.pods().list()).getItems()) {
            String podName = pod.getMetadata().getName();
            logs.put(podName, ((PodResource)this.client.pods().withName(podName)).getLog());
        }
        return logs;
    }

    public Map<String, String> logs(Service service) {
        HashMap<String, String> logs = new HashMap<String, String>();
        for (Pod pod : this.podsInService(service)) {
            if (!this.isPodRunning(pod)) continue;
            String podName = pod.getMetadata().getName();
            logs.put(podName, ((PodResource)this.client.pods().withName(podName)).getLog());
        }
        return logs;
    }

    public String host() {
        String nodeURL = this.client.network().getConfiguration().getMasterUrl();
        try {
            URI uri = new URI(nodeURL);
            return uri.getHost();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public int port(Service service) {
        String serviceName = service.getName();
        io.fabric8.kubernetes.api.model.Service serviceModel = (io.fabric8.kubernetes.api.model.Service)((ServiceResource)this.client.services().withName(serviceName)).get();
        if (serviceModel == null || serviceModel.getSpec() == null || serviceModel.getSpec().getPorts() == null) {
            Assertions.fail((String)("Service " + serviceName + " not found"));
        }
        return serviceModel.getSpec().getPorts().stream().map(ServicePort::getNodePort).filter(Objects::nonNull).findFirst().orElse(80);
    }

    public void deleteNamespace() {
        if (ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean().booleanValue()) {
            try {
                new Command(new String[]{KUBECTL, "delete", "namespace", this.currentNamespace}).runAndWait();
            }
            catch (Exception e) {
                Assertions.fail((String)("Project failed to be deleted. Caused by " + e.getMessage()));
            }
            finally {
                this.client.close();
            }
        } else {
            this.deleteResourcesByLabel(LABEL_SCENARIO_ID, this.getScenarioId());
        }
    }

    public String getScenarioId() {
        return this.scenarioId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteResourcesByLabel(String labelName, String labelValue) {
        try {
            String label = String.format("%s=%s", labelName, labelValue);
            new Command(new String[]{KUBECTL, "delete", "-n", this.currentNamespace, "all", "-l", label}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Project failed to be deleted. Caused by " + e.getMessage()));
        }
        finally {
            this.client.close();
        }
    }

    private boolean isPodRunning(Pod pod) {
        return pod.getStatus().getPhase().equals("Running");
    }

    private List<HasMetadata> loadYaml(String template) {
        NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable load = this.client.load((InputStream)new ByteArrayInputStream(template.getBytes()));
        return load.items();
    }

    private String enrichTemplate(Service service, String template, Map<String, String> extraTemplateProperties) {
        List<HasMetadata> objects = this.loadYaml(template);
        for (HasMetadata obj : objects) {
            obj.getMetadata().setNamespace(this.namespace());
            Map objMetadataLabels = Optional.ofNullable(obj.getMetadata().getLabels()).orElse(new HashMap());
            objMetadataLabels.put(LABEL_SCENARIO_ID, this.getScenarioId());
            obj.getMetadata().setLabels(objMetadataLabels);
            if (!(obj instanceof Deployment)) continue;
            Deployment deployment = (Deployment)obj;
            deployment.getMetadata().setName(service.getName());
            deployment.getSpec().getTemplate().getMetadata().setNamespace(this.namespace());
            Map templateMetadataLabels = deployment.getSpec().getTemplate().getMetadata().getLabels();
            templateMetadataLabels.put(LABEL_TO_WATCH_FOR_LOGS, service.getName());
            templateMetadataLabels.put(LABEL_SCENARIO_ID, this.getScenarioId());
            Map<String, String> enrichProperties = this.enrichProperties(service.getProperties(), deployment);
            enrichProperties.putAll(extraTemplateProperties);
            deployment.getSpec().getTemplate().getSpec().getContainers().forEach(container -> enrichProperties.entrySet().forEach(property -> {
                String key = (String)property.getKey();
                EnvVar envVar = this.getEnvVarByKey(key, (Container)container);
                if (envVar == null) {
                    container.getEnv().add(new EnvVar(key, (String)property.getValue(), null));
                } else {
                    envVar.setValue((String)property.getValue());
                }
            }));
        }
        KubernetesList list = new KubernetesList();
        list.setItems(objects);
        return Serialization.asYaml((Object)list);
    }

    private EnvVar getEnvVarByKey(String key, Container container) {
        return container.getEnv().stream().filter(env -> StringUtils.equals((CharSequence)key, (CharSequence)env.getName())).findFirst().orElse(null);
    }

    private Map<String, String> enrichProperties(Map<String, String> properties, Deployment deployment) {
        HashMap<Object, CustomVolume> volumes = new HashMap<Object, CustomVolume>();
        HashMap<String, String> output = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Object propertyValue = entry.getValue();
            if (this.isResource(entry.getValue())) {
                path = entry.getValue().replace("resource::/", "");
                mountPath = this.getMountPath(path);
                filename = this.getFileName(path);
                String configMapName = this.normalizeConfigMapName(mountPath);
                this.createOrUpdateConfigMap(configMapName, filename, this.getFileContent(path));
                if (!volumes.containsKey(mountPath)) {
                    volumes.put(mountPath, new CustomVolume(configMapName, "", CustomVolume.VolumeType.CONFIG_MAP));
                }
                propertyValue = mountPath + PropertiesUtils.SLASH + filename;
            } else if (this.isResourceWithDestinationPath((String)propertyValue)) {
                path = ((String)propertyValue).replace("resource_with_destination::", "");
                if (!((String)propertyValue).matches(".*\\|.*")) {
                    String errorMsg = String.format("Unexpected %s format. Expected destinationPath|fileName but found %s", "resource_with_destination::", propertyValue);
                    throw new RuntimeException(errorMsg);
                }
                mountPath = path.split("\\|")[0];
                String fileName = path.split("\\|")[1];
                String fileNameNormalized = this.getFileName(fileName);
                String configMapName = this.normalizeConfigMapName(mountPath);
                this.createOrUpdateConfigMap(configMapName, fileNameNormalized, this.getFileContent(fileName));
                propertyValue = mountPath + PropertiesUtils.SLASH + fileNameNormalized;
                if (!volumes.containsKey(mountPath)) {
                    volumes.put(propertyValue, new CustomVolume(configMapName, fileNameNormalized, CustomVolume.VolumeType.CONFIG_MAP));
                }
            } else if (this.isSecret(entry.getValue())) {
                path = entry.getValue().replace("secret::/", "");
                mountPath = this.getMountPath(path);
                filename = this.getFileName(path);
                String secretName = this.normalizeConfigMapName(path);
                this.doCreateSecretFromFile(secretName, this.getFilePath(path));
                volumes.put(mountPath, new CustomVolume(secretName, "", CustomVolume.VolumeType.SECRET));
                propertyValue = mountPath + PropertiesUtils.SLASH + filename;
            }
            output.put(entry.getKey(), (String)propertyValue);
        }
        for (Map.Entry<String, String> entry : volumes.entrySet()) {
            deployment.getSpec().getTemplate().getSpec().getVolumes().add(((CustomVolume)((Object)entry.getValue())).getVolume());
            deployment.getSpec().getTemplate().getSpec().getContainers().forEach(container -> container.getVolumeMounts().add(this.createVolumeMount(volume)));
        }
        return output;
    }

    private VolumeMount createVolumeMount(Map.Entry<String, CustomVolume> volume) {
        VolumeMountBuilder volumeMountBuilder = (VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(volume.getValue().getName())).withReadOnly(Boolean.valueOf(true))).withMountPath(volume.getKey());
        if (!volume.getValue().getSubFolderRegExp().isEmpty()) {
            volumeMountBuilder.withSubPathExpr(volume.getValue().getSubFolderRegExp());
        }
        return volumeMountBuilder.build();
    }

    private boolean isResourceWithDestinationPath(String key) {
        return key.startsWith("resource_with_destination::");
    }

    private void createOrUpdateConfigMap(String configMapName, String key, String value) {
        if (((Resource)this.client.configMaps().withName(configMapName)).get() != null) {
            ((Resource)this.client.configMaps().withName(configMapName)).edit(configMap -> {
                configMap.getData().put(key, value);
                return configMap;
            });
        } else {
            ((Resource)this.client.configMaps().resource((Object)((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapName)).endMetadata()).addToData(key, value)).build())).createOr(Updatable::update);
        }
    }

    private void doCreateSecretFromFile(String name, String filePath) {
        if (((Resource)this.client.secrets().withName(name)).get() == null) {
            try {
                new Command(new String[]{KUBECTL, "create", "secret", "generic", name, "--from-file=" + filePath, "-n", this.currentNamespace}).runAndWait();
            }
            catch (Exception e) {
                Assertions.fail((String)("Could not create secret. Caused by " + e.getMessage()));
            }
        }
    }

    private String getFileName(String path) {
        if (!path.contains(PropertiesUtils.SLASH)) {
            return path;
        }
        return path.substring(path.lastIndexOf(PropertiesUtils.SLASH) + 1);
    }

    private String getMountPath(String path) {
        if (!path.contains(PropertiesUtils.SLASH)) {
            return RESOURCE_MNT_FOLDER;
        }
        Object mountPath = (String)StringUtils.defaultIfEmpty((CharSequence)path.substring(0, path.lastIndexOf(PropertiesUtils.SLASH)), (CharSequence)RESOURCE_MNT_FOLDER);
        if (!path.startsWith(PropertiesUtils.SLASH)) {
            mountPath = PropertiesUtils.SLASH + (String)mountPath;
        }
        return mountPath;
    }

    private String getFileContent(String path) {
        String filePath = this.getFilePath(path);
        if (Files.exists(Path.of(filePath, new String[0]), new LinkOption[0])) {
            return FileUtils.loadFile((File)Path.of(filePath, new String[0]).toFile());
        }
        return FileUtils.loadFile((String)filePath);
    }

    private String getFilePath(String path) {
        String string;
        block8: {
            Stream<Path> binariesFound = Files.find(PropertiesUtils.TARGET, Integer.MAX_VALUE, (file, basicFileAttributes) -> file.toString().contains(path), new FileVisitOption[0]);
            try {
                string = binariesFound.map(Path::toString).findFirst().orElse(path);
                if (binariesFound == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (binariesFound != null) {
                        try {
                            binariesFound.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return path;
                }
            }
            binariesFound.close();
        }
        return string;
    }

    private String normalizeConfigMapName(String name) {
        return StringUtils.removeStart((String)name, (String)PropertiesUtils.SLASH).replaceAll(Pattern.quote("."), "-").replaceAll(PropertiesUtils.SLASH, "-");
    }

    private boolean isResource(String key) {
        return key.startsWith("resource::/");
    }

    private boolean isSecret(String key) {
        return key.startsWith("secret::/");
    }

    private String createNamespace() {
        boolean namespaceCreated = false;
        String namespace = this.generateRandomNamespaceName();
        for (int index = 0; index < 5; ++index) {
            if (this.doCreateNamespace(namespace)) {
                namespaceCreated = true;
                break;
            }
            namespace = this.generateRandomNamespaceName();
        }
        if (!namespaceCreated) {
            Assertions.fail((String)"Namespace cannot be created. Review your Kubernetes installation.");
        }
        return namespace;
    }

    private boolean doCreateNamespace(String namespaceName) {
        boolean created = false;
        try {
            new Command(new String[]{KUBECTL, "create", "namespace", namespaceName}).runAndWait();
            created = true;
        }
        catch (Exception e) {
            Log.warn((String)("Namespace " + namespaceName + " failed to be created. Caused by: " + e.getMessage() + ". Trying again."), (Object[])new Object[0]);
        }
        return created;
    }

    private String generateRandomNamespaceName() {
        return ThreadLocalRandom.current().ints(10L, 97, 123).collect(() -> new StringBuilder("ts-"), StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private boolean setCurrentSessionNamespace(String namespaceName) {
        boolean done = false;
        try {
            new Command(new String[]{KUBECTL, "config", "set-context", "--current", "--namespace=" + namespaceName}).runAndWait();
            done = true;
        }
        catch (Exception e) {
            Log.warn((String)("Namespace " + namespaceName + " failed to be set as current session namespace. Caused by: " + e.getMessage() + ". Trying again."), (Object[])new Object[0]);
        }
        return done;
    }

    private void printServiceInfo(Service service) {
        try {
            new Command(new String[]{KUBECTL, "get", "svc", service.getName(), "-n", this.currentNamespace}).outputToConsole().runAndWait();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

