/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.inject.KubectlClient;
import io.quarkus.test.logging.KubernetesLoggingHandler;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.services.URILike;
import io.quarkus.test.services.containers.ContainerManagedResourceBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class KubernetesContainerManagedResource
implements ManagedResource {
    private static final String DEPLOYMENT_SERVICE_PROPERTY = "kubernetes.service";
    private static final String DEPLOYMENT_TEMPLATE_PROPERTY = "kubernetes.template";
    private static final String USE_INTERNAL_SERVICE_AS_URL_PROPERTY = "kubernetes.use-internal-service-as-url";
    private static final String DEPLOYMENT_TEMPLATE_PROPERTY_DEFAULT = "/kubernetes-deployment-template.yml";
    private static final String DEPLOYMENT = "kubernetes.yml";
    private final ContainerManagedResourceBuilder model;
    private final KubectlClient client;
    private LoggingHandler loggingHandler;
    private boolean running;

    protected KubernetesContainerManagedResource(ContainerManagedResourceBuilder model) {
        this.model = model;
        this.client = (KubectlClient)model.getContext().get("kubectl-client");
    }

    public String getDisplayName() {
        return this.model.getImage();
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.applyDeployment();
        this.client.expose(this.model.getContext().getOwner(), this.model.getPort());
        this.client.scaleTo(this.model.getContext().getOwner(), 1);
        this.running = true;
        this.loggingHandler = new KubernetesLoggingHandler(this.model.getContext());
        this.loggingHandler.startWatching();
    }

    public void stop() {
        if (this.loggingHandler != null) {
            this.loggingHandler.stopWatching();
        }
        this.client.scaleTo(this.model.getContext().getOwner(), 0);
        this.running = false;
    }

    public URILike getURI(Protocol protocol) {
        if (this.useInternalServiceAsUrl()) {
            return this.createURI(protocol.getValue(), this.model.getContext().getName(), this.model.getPort());
        }
        return this.createURI("http", this.client.host(), this.client.port(this.model.getContext().getOwner()));
    }

    public boolean isRunning() {
        return this.loggingHandler != null && this.loggingHandler.logsContains(this.model.getExpectedLog());
    }

    public List<String> logs() {
        return this.loggingHandler.logs();
    }

    private void applyDeployment() {
        String deploymentFile = this.model.getContext().getOwner().getConfiguration().getOrDefault(DEPLOYMENT_TEMPLATE_PROPERTY, DEPLOYMENT_TEMPLATE_PROPERTY_DEFAULT);
        this.client.applyServiceProperties(this.model.getContext().getOwner(), deploymentFile, this::replaceDeploymentContent, this.model.getContext().getServiceFolder().resolve(DEPLOYMENT));
    }

    private String replaceDeploymentContent(String content) {
        String customServiceName = this.model.getContext().getOwner().getConfiguration().get(DEPLOYMENT_SERVICE_PROPERTY);
        if (StringUtils.isNotEmpty((CharSequence)customServiceName)) {
            content = content.replaceAll(Pattern.quote(customServiceName), this.model.getContext().getName());
        }
        String args = Arrays.stream(this.model.getCommand()).map(cmd -> "\"" + cmd + "\"").collect(Collectors.joining(", "));
        return content.replaceAll(Pattern.quote("${IMAGE}"), this.model.getImage()).replaceAll(Pattern.quote("${SERVICE_NAME}"), this.model.getContext().getName()).replaceAll(Pattern.quote("${INTERNAL_PORT}"), "" + this.model.getPort()).replaceAll(Pattern.quote("${ARGS}"), args);
    }

    private boolean useInternalServiceAsUrl() {
        return Boolean.TRUE.toString().equals(this.model.getContext().getOwner().getConfiguration().get(USE_INTERNAL_SERVICE_AS_URL_PROPERTY));
    }
}

