/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.quarkus.test.logging.TestContainersLoggingHandler;
import io.quarkus.test.services.containers.DockerContainerManagedResource;
import io.quarkus.test.services.containers.KafkaContainerManagedResourceBuilder;
import org.apache.commons.lang3.StringUtils;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.MountableFile;

public abstract class BaseKafkaContainerManagedResource
extends DockerContainerManagedResource {
    private static final String SERVER_PROPERTIES = "server.properties";
    protected final KafkaContainerManagedResourceBuilder model;
    private GenericContainer<?> schemaRegistry;
    private TestContainersLoggingHandler schemaRegistryLoggingHandler;
    private Network network;

    protected BaseKafkaContainerManagedResource(KafkaContainerManagedResourceBuilder model) {
        super(model.getContext());
        this.model = model;
    }

    protected abstract GenericContainer<?> initKafkaContainer();

    protected abstract GenericContainer<?> initRegistryContainer(GenericContainer<?> var1);

    public void start() {
        super.start();
        this.startRegistryIfEnabled();
    }

    public void stop() {
        super.stop();
        this.stopRegistryIfEnabled();
    }

    public boolean isRunning() {
        return super.isRunning() && (!this.model.isWithRegistry() || this.isRegistryRunning());
    }

    protected String getKafkaVersion() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.model.getVersion(), (CharSequence)this.model.getVendor().getDefaultVersion());
    }

    protected String getKafkaRegistryImage() {
        return this.model.getRegistryImageVersion();
    }

    protected int getKafkaRegistryPort() {
        return this.model.getVendor().getRegistry().getPort();
    }

    protected GenericContainer<?> initContainer() {
        GenericContainer<?> kafkaContainer = this.initKafkaContainer();
        String kafkaConfigPath = this.model.getKafkaConfigPath();
        if (StringUtils.isNotEmpty((CharSequence)this.getServerProperties())) {
            kafkaContainer.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.getServerProperties()), kafkaConfigPath + SERVER_PROPERTIES);
        }
        for (String resource : this.getKafkaConfigResources()) {
            kafkaContainer.withCopyFileToContainer(MountableFile.forClasspathResource((String)resource), kafkaConfigPath + resource);
        }
        if (this.model.isWithRegistry()) {
            this.schemaRegistry = this.initRegistryContainer(kafkaContainer);
            this.schemaRegistryLoggingHandler = new TestContainersLoggingHandler(this.model.getContext().getOwner(), this.schemaRegistry);
            this.network = Network.newNetwork();
            kafkaContainer.withNetwork(this.network);
            this.schemaRegistry.withNetwork(this.network);
        }
        return kafkaContainer;
    }

    protected int getTargetPort() {
        return this.model.getVendor().getPort();
    }

    protected String[] getKafkaConfigResources() {
        return this.model.getKafkaConfigResources();
    }

    protected String getServerProperties() {
        return this.model.getServerProperties();
    }

    private void startRegistryIfEnabled() {
        if (this.model.isWithRegistry()) {
            this.schemaRegistryLoggingHandler.startWatching();
            if (!this.isRegistryRunning()) {
                this.schemaRegistry.start();
            }
            this.model.getContext().put("ts.kafka.registry.url", (Object)this.getSchemaRegistryUrl());
        }
    }

    private void stopRegistryIfEnabled() {
        if (this.model.isWithRegistry() && this.isRegistryRunning()) {
            this.schemaRegistryLoggingHandler.stopWatching();
            this.schemaRegistry.stop();
        }
        if (this.network != null) {
            this.network.close();
        }
    }

    private boolean isRegistryRunning() {
        return this.schemaRegistry != null && this.schemaRegistry.isRunning();
    }

    private String getSchemaRegistryUrl() {
        String path = (String)StringUtils.defaultIfBlank((CharSequence)this.model.getRegistryPath(), (CharSequence)this.model.getVendor().getRegistry().getPath());
        String containerIp = this.schemaRegistry.getContainerIpAddress();
        return String.format("http://%s:%s%s", containerIp, this.schemaRegistry.getMappedPort(this.getKafkaRegistryPort()), path);
    }
}

