/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.ManagedResourceBuilder;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.services.KafkaContainer;
import io.quarkus.test.services.containers.ConfluentKafkaContainerManagedResource;
import io.quarkus.test.services.containers.KafkaContainerManagedResourceBinding;
import io.quarkus.test.services.containers.StrimziKafkaContainerManagedResource;
import io.quarkus.test.services.containers.model.KafkaProtocol;
import io.quarkus.test.services.containers.model.KafkaVendor;
import io.quarkus.test.utils.PropertiesUtils;
import java.lang.annotation.Annotation;
import java.util.ServiceLoader;

public class KafkaContainerManagedResourceBuilder
implements ManagedResourceBuilder {
    private final ServiceLoader<KafkaContainerManagedResourceBinding> managedResourceBindingsRegistry = ServiceLoader.load(KafkaContainerManagedResourceBinding.class);
    private ServiceContext context;
    private KafkaVendor vendor;
    private String image;
    private String version;
    private boolean withRegistry;
    private String registryImage;
    private String registryPath;
    private KafkaProtocol protocol = KafkaProtocol.PLAIN_TEXT;
    private String kafkaConfigPath;
    private String serverProperties;
    private String[] kafkaConfigResources;

    protected KafkaVendor getVendor() {
        return this.vendor;
    }

    protected String getImage() {
        return this.image;
    }

    protected String getVersion() {
        return this.version;
    }

    protected ServiceContext getContext() {
        return this.context;
    }

    protected boolean isWithRegistry() {
        return this.withRegistry;
    }

    protected String getDefaultRegistryImageVersion() {
        String defaultImage = this.getVendor().getRegistry().getImage();
        String defaultVersion = this.getVendor().getRegistry().getDefaultVersion();
        return defaultImage + ":" + defaultVersion;
    }

    protected String getRegistryImage() {
        return this.registryImage;
    }

    protected String getRegistryPath() {
        return this.registryPath;
    }

    protected KafkaProtocol getProtocol() {
        return this.protocol;
    }

    protected String getKafkaConfigPath() {
        return this.kafkaConfigPath;
    }

    protected String getServerProperties() {
        return this.serverProperties;
    }

    protected String[] getKafkaConfigResources() {
        return this.kafkaConfigResources;
    }

    protected String getRegistryImageVersion() {
        Object registryImage = this.getDefaultRegistryImageVersion();
        if (!this.getRegistryImage().isEmpty()) {
            String defaultVersion = this.getVendor().getRegistry().getDefaultVersion();
            registryImage = this.getRegistryImage();
            if (!((String)registryImage).contains(":")) {
                registryImage = (String)registryImage + ":" + defaultVersion;
            }
        }
        return ((String)registryImage).toLowerCase();
    }

    public void init(Annotation annotation) {
        KafkaContainer metadata = (KafkaContainer)annotation;
        this.vendor = metadata.vendor();
        this.image = PropertiesUtils.resolveProperty((String)metadata.image());
        this.version = PropertiesUtils.resolveProperty((String)metadata.version());
        this.withRegistry = metadata.withRegistry();
        this.registryImage = PropertiesUtils.resolveProperty((String)metadata.registryImage());
        this.registryPath = PropertiesUtils.resolveProperty((String)metadata.registryPath());
        this.protocol = metadata.protocol();
        this.kafkaConfigPath = PropertiesUtils.resolveProperty((String)metadata.kafkaConfigPath());
        this.serverProperties = PropertiesUtils.resolveProperty((String)metadata.serverProperties());
        this.kafkaConfigResources = metadata.kafkaConfigResources();
    }

    public ManagedResource build(ServiceContext context) {
        this.context = context;
        for (KafkaContainerManagedResourceBinding binding : this.managedResourceBindingsRegistry) {
            if (!binding.appliesFor(this)) continue;
            return binding.init(this);
        }
        if (this.vendor == KafkaVendor.STRIMZI) {
            return new StrimziKafkaContainerManagedResource(this);
        }
        return new ConfluentKafkaContainerManagedResource(this);
    }
}

