/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.quarkus.test.bootstrap.DefaultService;
import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.bootstrap.inject.OpenShiftClient;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.logging.OpenShiftLoggingHandler;
import io.quarkus.test.services.containers.KafkaContainerManagedResourceBuilder;
import io.quarkus.test.services.containers.model.KafkaProtocol;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public class OpenShiftStrimziKafkaContainerManagedResource
implements ManagedResource {
    private static final String DEPLOYMENT_SERVICE_PROPERTY = "openshift.service";
    private static final String DEPLOYMENT_TEMPLATE_PROPERTY = "openshift.template";
    private static final String DEPLOYMENT_TEMPLATE_PROPERTY_DEFAULT = "/strimzi-deployment-template.yml";
    private static final String DEPLOYMENT = "kafka.yml";
    private static final String REGISTRY_DEPLOYMENT_TEMPLATE_PROPERTY_DEFAULT = "/registry-deployment-template.yml";
    private static final String REGISTRY_DEPLOYMENT = "registry.yml";
    private static final String EXPECTED_LOG = "started (kafka.server.KafkaServer)";
    private static final int HTTP_PORT = 9092;
    private final KafkaContainerManagedResourceBuilder model;
    private final OpenShiftClient client;
    private DefaultService registry;
    private LoggingHandler loggingHandler;
    private boolean running;

    protected OpenShiftStrimziKafkaContainerManagedResource(KafkaContainerManagedResourceBuilder model) {
        this.model = model;
        this.client = (OpenShiftClient)model.getContext().get("openshift-client");
    }

    public String getDisplayName() {
        return this.getKafkaImage() + ":" + this.getKafkaVersion();
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.applyDeployment();
        this.client.scaleTo(this.model.getContext().getOwner(), 1);
        if (this.model.isWithRegistry()) {
            this.createRegistryService();
            this.applyRegistryDeployment();
        }
        this.running = true;
        this.loggingHandler = new OpenShiftLoggingHandler(this.model.getContext());
        this.loggingHandler.startWatching();
    }

    public void stop() {
        if (this.loggingHandler != null) {
            this.loggingHandler.stopWatching();
        }
        this.client.scaleTo(this.model.getContext().getOwner(), 0);
        this.running = false;
    }

    public String getHost(Protocol protocol) {
        return this.model.getContext().getOwner().getName();
    }

    public int getPort(Protocol protocol) {
        return 9092;
    }

    public boolean isRunning() {
        return this.loggingHandler != null && this.loggingHandler.logsContains(EXPECTED_LOG);
    }

    public List<String> logs() {
        return this.loggingHandler.logs();
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void validate() {
        if (this.model.getProtocol() != KafkaProtocol.PLAIN_TEXT) {
            Assertions.fail((String)"Only PLAIN_TEXT protocol is supported on OpenShift deployments");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.model.getServerProperties())) {
            Assertions.fail((String)"Custom server.properties is not supported on OpenShift deployments");
        }
        if (this.model.getKafkaConfigResources().length > 0) {
            Assertions.fail((String)"Custom kafka config resources is not supported on OpenShift deployments");
        }
    }

    private void createRegistryService() {
        this.registry = new DefaultService();
        this.registry.register("registry", this.model.getContext().getScenarioContext());
    }

    private void applyDeployment() {
        String deploymentFile = this.model.getContext().getOwner().getConfiguration().getOrDefault(DEPLOYMENT_TEMPLATE_PROPERTY, DEPLOYMENT_TEMPLATE_PROPERTY_DEFAULT);
        this.client.applyServicePropertiesUsingTemplate(this.model.getContext().getOwner(), deploymentFile, this::replaceDeploymentContent, this.model.getContext().getServiceFolder().resolve(DEPLOYMENT));
    }

    private void applyRegistryDeployment() {
        int registryPort = this.model.getVendor().getRegistry().getPort();
        this.client.applyServicePropertiesUsingTemplate((Service)this.registry, REGISTRY_DEPLOYMENT_TEMPLATE_PROPERTY_DEFAULT, content -> content.replaceAll(Pattern.quote("${KAFKA_BOOTSTRAP_URL}"), this.getKafkaBootstrapUrl()).replaceAll(Pattern.quote("${KAFKA_REGISTRY_IMAGE}"), this.getKafkaRegistryImage()).replaceAll(Pattern.quote("${KAFKA_REGISTRY_PORT}"), "" + registryPort), this.model.getContext().getServiceFolder().resolve(REGISTRY_DEPLOYMENT));
        this.client.expose((Service)this.registry, registryPort);
        this.client.scaleTo((Service)this.registry, 1);
        this.model.getContext().put("ts.kafka.registry.url", (Object)this.getSchemaRegistryUrl());
    }

    private String getSchemaRegistryUrl() {
        String path = (String)StringUtils.defaultIfBlank((CharSequence)this.model.getRegistryPath(), (CharSequence)this.model.getVendor().getRegistry().getPath());
        return this.client.url((Service)this.registry) + path;
    }

    private String getKafkaBootstrapUrl() {
        return this.getHost(Protocol.HTTP).replace("http://", "") + ":" + this.getPort(Protocol.HTTP);
    }

    private String replaceDeploymentContent(String content) {
        String customServiceName = this.model.getContext().getOwner().getConfiguration().get(DEPLOYMENT_SERVICE_PROPERTY);
        if (StringUtils.isNotEmpty((CharSequence)customServiceName)) {
            content = content.replaceAll(Pattern.quote(customServiceName), this.model.getContext().getOwner().getName());
        }
        return content.replaceAll(Pattern.quote("${IMAGE}"), this.getKafkaImage()).replaceAll(Pattern.quote("${VERSION}"), this.getKafkaVersion()).replaceAll(Pattern.quote("${KAFKA_PORT}"), "" + this.model.getVendor().getPort()).replaceAll(Pattern.quote("${SERVICE_NAME}"), this.model.getContext().getName());
    }

    protected String getKafkaImage() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.model.getImage(), (CharSequence)this.model.getVendor().getImage());
    }

    protected String getKafkaVersion() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.model.getVersion(), (CharSequence)this.model.getVendor().getDefaultVersion());
    }

    protected String getKafkaRegistryImage() {
        return this.model.getRegistryImageVersion();
    }
}

