/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers.strimzi;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.quarkus.test.services.containers.model.KafkaVendor;
import io.strimzi.StrimziKafkaContainer;
import java.nio.charset.StandardCharsets;
import org.testcontainers.images.builder.Transferable;

public class ExtendedStrimziKafkaContainer
extends StrimziKafkaContainer {
    private static final String KAFKA_MAPPED_PORT = "${KAFKA_MAPPED_PORT}";
    private static final int ALLOW_EXEC = 700;
    private boolean useCustomServerProperties = false;

    public ExtendedStrimziKafkaContainer(String version) {
        super(version);
    }

    public void useCustomServerProperties() {
        this.useCustomServerProperties = true;
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo, boolean reused) {
        if (this.useCustomServerProperties) {
            int kafkaExposedPort = this.getMappedPort(KafkaVendor.STRIMZI.getPort());
            Object command = "#!/bin/bash \n";
            command = (String)command + "sed 's/${KAFKA_MAPPED_PORT}/" + kafkaExposedPort + "/g' config/server.properties > /tmp/effective_server.properties &\n";
            command = (String)command + "bin/zookeeper-server-start.sh config/zookeeper.properties &\n";
            command = (String)command + "bin/kafka-server-start.sh /tmp/effective_server.properties";
            this.copyFileToContainer(Transferable.of((byte[])((String)command).getBytes(StandardCharsets.UTF_8), (int)700), "/testcontainers_start.sh");
        } else {
            super.containerIsStarting(containerInfo, reused);
        }
    }
}

