/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.operator;

import io.quarkus.test.bootstrap.OperatorService;
import io.quarkus.test.services.operator.model.KafkaInstanceCustomResource;

public class KafkaInstance
extends OperatorService<KafkaInstance> {
    private static final String HOST = "%s-kafka-bootstrap";
    private static final int PORT = 9092;
    private static final String KAFKA_INSTANCE_NAME_DEFAULT = "kafka-instance";
    private static final String KAFKA_INSTANCE_TEMPLATE_DEFAULT = "/strimzi-operator-kafka-instance.yaml";
    private final String name;

    public KafkaInstance() {
        this(KAFKA_INSTANCE_NAME_DEFAULT, KAFKA_INSTANCE_TEMPLATE_DEFAULT);
    }

    public KafkaInstance(String name, String crdFile) {
        this.name = name;
        this.withCrd(name, crdFile, KafkaInstanceCustomResource.class);
    }

    public String getHost() {
        return String.format(HOST, this.name);
    }

    public Integer getPort() {
        return 9092;
    }

    public String getBootstrapUrl() {
        return this.getHost() + ":" + this.getPort();
    }
}

