/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.quarkus.test.services.containers.BaseKafkaContainerManagedResource;
import io.quarkus.test.services.containers.KafkaContainerManagedResourceBuilder;
import io.quarkus.test.utils.DockerUtils;
import org.apache.commons.lang3.StringUtils;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.utility.DockerImageName;

public class ConfluentKafkaContainerManagedResource
extends BaseKafkaContainerManagedResource {
    protected ConfluentKafkaContainerManagedResource(KafkaContainerManagedResourceBuilder model) {
        super(model);
    }

    public String getDisplayName() {
        return this.getKafkaImage() + ":" + this.getKafkaVersion();
    }

    @Override
    protected GenericContainer<?> initKafkaContainer() {
        return new KafkaContainer(DockerImageName.parse((String)(this.getKafkaImage() + ":" + this.getKafkaVersion()))).withCreateContainerCmdModifier(cmd -> cmd.withName(DockerUtils.generateDockerContainerName()));
    }

    @Override
    protected GenericContainer<?> initRegistryContainer(GenericContainer<?> kafka) {
        GenericContainer schemaRegistry = new GenericContainer(DockerImageName.parse((String)this.getKafkaRegistryImage()));
        schemaRegistry.withExposedPorts(new Integer[]{this.getKafkaRegistryPort()});
        schemaRegistry.withEnv("SCHEMA_REGISTRY_HOST_NAME", "schema-registry");
        schemaRegistry.withEnv("SCHEMA_REGISTRY_LISTENERS", "http://0.0.0.0:" + this.getKafkaRegistryPort());
        schemaRegistry.withEnv("SCHEMA_REGISTRY_KAFKASTORE_BOOTSTRAP_SERVERS", "PLAINTEXT://" + (String)kafka.getNetworkAliases().get(0) + ":9092");
        schemaRegistry.withCreateContainerCmdModifier(cmd -> cmd.withName(DockerUtils.generateDockerContainerName()));
        return schemaRegistry;
    }

    protected String getKafkaImage() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.model.getImage(), (CharSequence)this.model.getVendor().getImage());
    }
}

