/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.services.URILike;
import io.quarkus.test.services.containers.BaseKafkaContainerManagedResource;
import io.quarkus.test.services.containers.KafkaContainerManagedResourceBuilder;
import io.quarkus.test.services.containers.model.KafkaProtocol;
import io.quarkus.test.services.containers.model.KafkaVendor;
import io.quarkus.test.services.containers.strimzi.ExtendedStrimziKafkaContainer;
import io.quarkus.test.utils.DockerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.testcontainers.containers.GenericContainer;

public class StrimziKafkaContainerManagedResource
extends BaseKafkaContainerManagedResource {
    private static final String SSL_SERVER_PROPERTIES_DEFAULT = "strimzi-default-server-ssl.properties";
    private static final String SSL_SERVER_KEYSTORE_DEFAULT = "strimzi-default-server-ssl-keystore.p12";
    private static final String SASL_SERVER_PROPERTIES_DEFAULT = "strimzi-default-server-sasl.properties";

    protected StrimziKafkaContainerManagedResource(KafkaContainerManagedResourceBuilder model) {
        super(model);
    }

    public String getDisplayName() {
        return KafkaVendor.STRIMZI.getImage() + this.getKafkaVersion();
    }

    public URILike getURI(Protocol protocol) {
        URILike uri = super.getURI(protocol);
        if (this.model.getProtocol() == KafkaProtocol.SSL) {
            uri = uri.withScheme("SSL");
        } else if (this.model.getProtocol() == KafkaProtocol.SASL) {
            uri = uri.withScheme("SASL_PLAINTEXT");
        }
        return uri;
    }

    @Override
    protected GenericContainer<?> initKafkaContainer() {
        ExtendedStrimziKafkaContainer container = new ExtendedStrimziKafkaContainer(this.getKafkaImageName(), this.getKafkaVersion());
        if (StringUtils.isNotEmpty((CharSequence)this.getServerProperties())) {
            container.useCustomServerProperties();
        }
        container.withCreateContainerCmdModifier(cmd -> cmd.withName(DockerUtils.generateDockerContainerName()));
        return container;
    }

    @Override
    protected GenericContainer<?> initRegistryContainer(GenericContainer<?> kafka) {
        GenericContainer schemaRegistry = new GenericContainer(this.getKafkaRegistryImage());
        schemaRegistry.withExposedPorts(new Integer[]{this.getKafkaRegistryPort()});
        schemaRegistry.withEnv("APPLICATION_ID", "registry_id");
        schemaRegistry.withEnv("APPLICATION_SERVER", "localhost:9000");
        schemaRegistry.withEnv("KAFKA_BOOTSTRAP_SERVERS", "PLAINTEXT://localhost:" + this.getTargetPort());
        schemaRegistry.withCreateContainerCmdModifier(cmd -> cmd.withName(DockerUtils.generateDockerContainerName()));
        return schemaRegistry;
    }

    @Override
    protected String getServerProperties() {
        if (StringUtils.isNotEmpty((CharSequence)this.model.getServerProperties())) {
            return this.model.getServerProperties();
        }
        if (this.model.getProtocol() == KafkaProtocol.SSL) {
            return SSL_SERVER_PROPERTIES_DEFAULT;
        }
        if (this.model.getProtocol() == KafkaProtocol.SASL) {
            return SASL_SERVER_PROPERTIES_DEFAULT;
        }
        return super.getServerProperties();
    }

    @Override
    protected String[] getKafkaConfigResources() {
        ArrayList<String> effectiveUserKafkaConfigResources = new ArrayList<String>();
        effectiveUserKafkaConfigResources.addAll(Arrays.asList(super.getKafkaConfigResources()));
        if (this.model.getProtocol() == KafkaProtocol.SSL) {
            effectiveUserKafkaConfigResources.add(SSL_SERVER_KEYSTORE_DEFAULT);
        }
        return effectiveUserKafkaConfigResources.toArray(new String[effectiveUserKafkaConfigResources.size()]);
    }
}

