/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dynamodb.runtime;

import io.quarkus.dynamodb.runtime.AwsConfig;
import io.quarkus.dynamodb.runtime.DynamodbConfig;
import io.quarkus.dynamodb.runtime.NettyHttpClientConfig;
import io.quarkus.dynamodb.runtime.SdkConfig;
import io.quarkus.dynamodb.runtime.SyncHttpClientConfig;
import java.net.URI;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.ProxyConfiguration;
import software.amazon.awssdk.http.nio.netty.SdkEventLoopGroup;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbBaseClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@ApplicationScoped
public class DynamodbClientProducer {
    private static final Log LOG = LogFactory.getLog(DynamodbClientProducer.class);
    private DynamodbConfig config;
    private DynamoDbClient client;
    private DynamoDbAsyncClient asyncClient;

    public void setConfig(DynamodbConfig config) {
        this.config = config;
    }

    @Produces
    @ApplicationScoped
    public DynamoDbClient client() {
        DynamoDbClientBuilder builder = DynamoDbClient.builder();
        this.initDynamodbBaseClient((DynamoDbBaseClientBuilder)builder, this.config);
        this.initHttpClient(builder, this.config.syncClient);
        this.client = (DynamoDbClient)builder.build();
        return this.client;
    }

    @Produces
    @ApplicationScoped
    public DynamoDbAsyncClient asyncClient() {
        DynamoDbAsyncClientBuilder builder = DynamoDbAsyncClient.builder();
        this.initDynamodbBaseClient((DynamoDbBaseClientBuilder)builder, this.config);
        this.initHttpClient(builder, this.config.asyncClient);
        this.asyncClient = (DynamoDbAsyncClient)builder.build();
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }

    private void initDynamodbBaseClient(DynamoDbBaseClientBuilder builder, DynamodbConfig config) {
        if (config.enableEndpointDiscovery) {
            builder.enableEndpointDiscovery();
        }
        this.initAwsClient((AwsClientBuilder)builder, config.aws);
        this.initSdkClient((SdkClientBuilder)builder, config.sdk);
    }

    private void initAwsClient(AwsClientBuilder builder, AwsConfig config) {
        config.region.ifPresent(arg_0 -> ((AwsClientBuilder)builder).region(arg_0));
        builder.credentialsProvider(config.credentials.type.create(config.credentials));
    }

    private void initSdkClient(SdkClientBuilder builder, SdkConfig config) {
        config.endpointOverride.filter(URI::isAbsolute).ifPresent(arg_0 -> ((SdkClientBuilder)builder).endpointOverride(arg_0));
        if (config.isClientOverrideConfig()) {
            ClientOverrideConfiguration.Builder overrides = ClientOverrideConfiguration.builder();
            config.apiCallTimeout.ifPresent(arg_0 -> ((ClientOverrideConfiguration.Builder)overrides).apiCallTimeout(arg_0));
            config.apiCallAttemptTimeout.ifPresent(arg_0 -> ((ClientOverrideConfiguration.Builder)overrides).apiCallAttemptTimeout(arg_0));
            config.interceptors.stream().map(this::createInterceptor).filter(Objects::nonNull).forEach(arg_0 -> ((ClientOverrideConfiguration.Builder)overrides).addExecutionInterceptor(arg_0));
            builder.overrideConfiguration((ClientOverrideConfiguration)overrides.build());
        }
    }

    private void initHttpClient(DynamoDbClientBuilder builder, SyncHttpClientConfig config) {
        if (config.type == SyncHttpClientConfig.SyncClientType.APACHE) {
            builder.httpClientBuilder((SdkHttpClient.Builder)this.createApacheClientBuilder(config));
        } else {
            builder.httpClientBuilder((SdkHttpClient.Builder)this.createUrlConnectionClientBuilder(config));
        }
    }

    private void initHttpClient(DynamoDbAsyncClientBuilder builder, NettyHttpClientConfig config) {
        builder.httpClientBuilder((SdkAsyncHttpClient.Builder)this.createNettyClientBuilder(config));
    }

    private UrlConnectionHttpClient.Builder createUrlConnectionClientBuilder(SyncHttpClientConfig config) {
        UrlConnectionHttpClient.Builder builder = UrlConnectionHttpClient.builder();
        builder.connectionTimeout(config.connectionTimeout);
        builder.socketTimeout(config.socketTimeout);
        return builder;
    }

    private ApacheHttpClient.Builder createApacheClientBuilder(SyncHttpClientConfig config) {
        ApacheHttpClient.Builder builder = ApacheHttpClient.builder();
        builder.connectionTimeout(config.connectionTimeout);
        builder.socketTimeout(config.socketTimeout);
        builder.connectionAcquisitionTimeout(config.apache.connectionAcquisitionTimeout);
        builder.connectionMaxIdleTime(config.apache.connectionMaxIdleTime);
        config.apache.connectionTimeToLive.ifPresent(arg_0 -> ((ApacheHttpClient.Builder)builder).connectionTimeToLive(arg_0));
        builder.expectContinueEnabled(Boolean.valueOf(config.apache.expectContinueEnabled));
        builder.maxConnections(Integer.valueOf(config.apache.maxConnections));
        builder.useIdleConnectionReaper(Boolean.valueOf(config.apache.useIdleConnectionReaper));
        if (config.apache.proxy.enabled) {
            ProxyConfiguration.Builder proxyBuilder = ProxyConfiguration.builder().endpoint(config.apache.proxy.endpoint);
            config.apache.proxy.username.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).username(arg_0));
            config.apache.proxy.password.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).password(arg_0));
            config.apache.proxy.nonProxyHosts.forEach(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).addNonProxyHost(arg_0));
            config.apache.proxy.ntlmDomain.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).ntlmDomain(arg_0));
            config.apache.proxy.ntlmWorkstation.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).ntlmWorkstation(arg_0));
            config.apache.proxy.preemptiveBasicAuthenticationEnabled.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).preemptiveBasicAuthenticationEnabled(arg_0));
            builder.proxyConfiguration((ProxyConfiguration)proxyBuilder.build());
        }
        builder.tlsKeyManagersProvider(config.apache.tlsManagersProvider.type.create(config.apache.tlsManagersProvider));
        return builder;
    }

    private NettyNioAsyncHttpClient.Builder createNettyClientBuilder(NettyHttpClientConfig config) {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        builder.connectionAcquisitionTimeout(config.connectionAcquisitionTimeout);
        builder.connectionMaxIdleTime(config.connectionMaxIdleTime);
        builder.connectionTimeout(config.connectionTimeout);
        config.connectionTimeToLive.ifPresent(arg_0 -> ((NettyNioAsyncHttpClient.Builder)builder).connectionTimeToLive(arg_0));
        builder.maxConcurrency(Integer.valueOf(config.maxConcurrency));
        builder.maxHttp2Streams(Integer.valueOf(config.maxHttp2Streams));
        builder.maxPendingConnectionAcquires(Integer.valueOf(config.maxPendingConnectionAcquires));
        builder.protocol(config.protocol);
        builder.readTimeout(config.readTimeout);
        builder.writeTimeout(config.writeTimeout);
        config.sslProvider.ifPresent(arg_0 -> ((NettyNioAsyncHttpClient.Builder)builder).sslProvider(arg_0));
        builder.useIdleConnectionReaper(Boolean.valueOf(config.useIdleConnectionReaper));
        if (config.proxy.enabled) {
            ProxyConfiguration.Builder proxyBuilder = software.amazon.awssdk.http.nio.netty.ProxyConfiguration.builder().scheme(config.proxy.endpoint.getScheme()).host(config.proxy.endpoint.getHost()).nonProxyHosts(new HashSet<String>(config.proxy.nonProxyHosts));
            if (config.proxy.endpoint.getPort() != -1) {
                proxyBuilder.port(config.proxy.endpoint.getPort());
            }
            builder.proxyConfiguration((software.amazon.awssdk.http.nio.netty.ProxyConfiguration)proxyBuilder.build());
        }
        builder.tlsKeyManagersProvider(config.tlsManagersProvider.type.create(config.tlsManagersProvider));
        if (config.eventLoop.override) {
            SdkEventLoopGroup.Builder eventLoopBuilder = SdkEventLoopGroup.builder();
            config.eventLoop.numberOfThreads.ifPresent(arg_0 -> ((SdkEventLoopGroup.Builder)eventLoopBuilder).numberOfThreads(arg_0));
            if (config.eventLoop.threadNamePrefix.isPresent()) {
                eventLoopBuilder.threadFactory(new ThreadFactoryBuilder().threadNamePrefix(config.eventLoop.threadNamePrefix.get()).build());
            }
            builder.eventLoopGroupBuilder(eventLoopBuilder);
        }
        return builder;
    }

    private ExecutionInterceptor createInterceptor(Class<?> interceptorClass) {
        try {
            return (ExecutionInterceptor)Class.forName(interceptorClass.getName()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error((Object)"Unable to create interceptor", (Throwable)e);
            return null;
        }
    }
}

