/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dynamodb.runtime;

import java.util.Optional;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.Converter;
import software.amazon.awssdk.regions.Region;

@Priority(value=200)
public class RegionConverter
implements Converter<Region> {
    public Region convert(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        Optional<Region> regionFound = Region.regions().stream().filter(region -> value.equals(region.id())).findAny();
        return regionFound.orElseThrow(() -> new IllegalArgumentException(String.format("value %s is not a valid AWS Region %s", value, Region.regions().toString())));
    }
}

