/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dynamodb.runtime;

import io.quarkus.dynamodb.runtime.TlsManagersProviderConfig;
import java.nio.file.Path;
import software.amazon.awssdk.http.FileStoreTlsKeyManagersProvider;
import software.amazon.awssdk.http.SystemPropertyTlsKeyManagersProvider;
import software.amazon.awssdk.http.TlsKeyManagersProvider;

public enum TlsManagersProviderType {
    NONE{

        @Override
        public TlsKeyManagersProvider create(TlsManagersProviderConfig config) {
            return TlsKeyManagersProvider.noneProvider();
        }
    }
    ,
    SYSTEM_PROPERTY{

        @Override
        public TlsKeyManagersProvider create(TlsManagersProviderConfig config) {
            return SystemPropertyTlsKeyManagersProvider.create();
        }
    }
    ,
    FILE_STORE{

        @Override
        public TlsKeyManagersProvider create(TlsManagersProviderConfig config) {
            return FileStoreTlsKeyManagersProvider.create((Path)config.fileStore.path, (String)config.fileStore.type, (String)config.fileStore.password);
        }
    };


    public abstract TlsKeyManagersProvider create(TlsManagersProviderConfig var1);
}

