/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.dynamodb.runtime;

import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;

@ApplicationScoped
public class DynamodbClientProducer {
    private volatile DynamoDbClientBuilder syncConfiguredBuilder;
    private volatile DynamoDbAsyncClientBuilder asyncConfiguredBuilder;
    private DynamoDbClient client;
    private DynamoDbAsyncClient asyncClient;

    @Produces
    @ApplicationScoped
    public DynamoDbClient client() {
        this.client = (DynamoDbClient)this.syncConfiguredBuilder.build();
        return this.client;
    }

    @Produces
    @ApplicationScoped
    public DynamoDbAsyncClient asyncClient() {
        this.asyncClient = (DynamoDbAsyncClient)this.asyncConfiguredBuilder.build();
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }

    public void setSyncConfiguredBuilder(DynamoDbClientBuilder syncConfiguredBuilder) {
        this.syncConfiguredBuilder = syncConfiguredBuilder;
    }

    public void setAsyncConfiguredBuilder(DynamoDbAsyncClientBuilder asyncConfiguredBuilder) {
        this.asyncConfiguredBuilder = asyncConfiguredBuilder;
    }
}

