/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.iam.deployment;

import io.quarkus.amazon.common.deployment.AbstractAmazonServiceProcessor;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonHttpClients;
import io.quarkus.amazon.common.runtime.AmazonClientApacheTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientNettyTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientUrlConnectionTransportRecorder;
import io.quarkus.amazon.iam.runtime.IamBuildTimeConfig;
import io.quarkus.amazon.iam.runtime.IamClientProducer;
import io.quarkus.amazon.iam.runtime.IamConfig;
import io.quarkus.amazon.iam.runtime.IamRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import java.util.List;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.IamAsyncClientBuilder;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.IamClientBuilder;

public class IamProcessor
extends AbstractAmazonServiceProcessor {
    IamBuildTimeConfig buildTimeConfig;

    protected Feature amazonServiceClientName() {
        return Feature.AMAZON_IAM;
    }

    protected String configName() {
        return "iam";
    }

    protected DotName syncClientName() {
        return DotName.createSimple((String)IamClient.class.getName());
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)IamAsyncClient.class.getName());
    }

    protected String builtinInterceptorsPath() {
        return "software/amazon/awssdk/services/iam/execution.interceptors";
    }

    @BuildStep
    AdditionalBeanBuildItem producer() {
        return AdditionalBeanBuildItem.unremovableOf(IamClientProducer.class);
    }

    @BuildStep
    void setup(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors, BuildProducer<AmazonClientBuildItem> clientProducer) {
        this.setupExtension(beanRegistrationPhase, extensionSslNativeSupport, feature, interceptors, clientProducer, this.buildTimeConfig.sdk, this.buildTimeConfig.syncClient);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonApacheHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupApacheSyncTransport(List<AmazonClientBuildItem> amazonClients, IamRecorder recorder, AmazonClientApacheTransportRecorder transportRecorder, IamConfig runtimeConfig, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createApacheSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient, recorder.getSyncConfig(runtimeConfig), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonUrlConnectionHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupUrlConnectionSyncTransport(List<AmazonClientBuildItem> amazonClients, IamRecorder recorder, AmazonClientUrlConnectionTransportRecorder transportRecorder, IamConfig runtimeConfig, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createUrlConnectionSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient, recorder.getSyncConfig(runtimeConfig), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonNettyHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupNettyAsyncTransport(List<AmazonClientBuildItem> amazonClients, IamRecorder recorder, AmazonClientNettyTransportRecorder transportRecorder, IamConfig runtimeConfig, BuildProducer<AmazonClientAsyncTransportBuildItem> asyncTransports) {
        this.createNettyAsyncTransportBuilder(amazonClients, transportRecorder, recorder.getAsyncConfig(runtimeConfig), asyncTransports);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createClientBuilders(IamRecorder recorder, AmazonClientRecorder commonRecorder, IamConfig runtimeConfig, List<AmazonClientSyncTransportBuildItem> syncTransports, List<AmazonClientAsyncTransportBuildItem> asyncTransports, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        this.createClientBuilders(commonRecorder, recorder.getAwsConfig(runtimeConfig), recorder.getSdkConfig(runtimeConfig), this.buildTimeConfig.sdk, syncTransports, asyncTransports, IamClientBuilder.class, syncTransport -> recorder.createSyncBuilder(runtimeConfig, syncTransport), IamAsyncClientBuilder.class, asyncTransport -> recorder.createAsyncBuilder(runtimeConfig, asyncTransport), syntheticBeans);
    }
}

