/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.iam.runtime;

import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.IamAsyncClientBuilder;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.IamClientBuilder;

@ApplicationScoped
public class IamClientProducer {
    private final IamClient syncClient;
    private final IamAsyncClient asyncClient;

    IamClientProducer(Instance<IamClientBuilder> syncClientBuilderInstance, Instance<IamAsyncClientBuilder> asyncClientBuilderInstance) {
        this.syncClient = syncClientBuilderInstance.isResolvable() ? (IamClient)((IamClientBuilder)syncClientBuilderInstance.get()).build() : null;
        this.asyncClient = asyncClientBuilderInstance.isResolvable() ? (IamAsyncClient)((IamAsyncClientBuilder)asyncClientBuilderInstance.get()).build() : null;
    }

    @Produces
    @ApplicationScoped
    public IamClient client() {
        if (this.syncClient == null) {
            throw new IllegalStateException("The IamClient is required but has not been detected/configured.");
        }
        return this.syncClient;
    }

    @Produces
    @ApplicationScoped
    public IamAsyncClient asyncClient() {
        if (this.asyncClient == null) {
            throw new IllegalStateException("The IamAsyncClient is required but has not been detected/configured.");
        }
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.syncClient != null) {
            this.syncClient.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }
}

