/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.kms.deployment;

import io.quarkus.amazon.common.deployment.AbstractAmazonServiceProcessor;
import io.quarkus.amazon.common.deployment.AmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientBuilderBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientBuilderConfiguredBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientTransportsBuildItem;
import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientTransportRecorder;
import io.quarkus.amazon.kms.runtime.KmsBuildTimeConfig;
import io.quarkus.amazon.kms.runtime.KmsClientProducer;
import io.quarkus.amazon.kms.runtime.KmsConfig;
import io.quarkus.amazon.kms.runtime.KmsRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.runtime.ShutdownContext;
import java.util.List;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.KmsClient;

public class KmsProcessor
extends AbstractAmazonServiceProcessor {
    KmsBuildTimeConfig buildTimeConfig;

    protected Feature amazonServiceClientName() {
        return Feature.AMAZON_KMS;
    }

    protected String configName() {
        return "kms";
    }

    protected DotName syncClientName() {
        return DotName.createSimple((String)KmsClient.class.getName());
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)KmsAsyncClient.class.getName());
    }

    protected String builtinInterceptorsPath() {
        return "software/amazon/awssdk/services/kms/execution.interceptors";
    }

    @BuildStep
    AdditionalBeanBuildItem producer() {
        return AdditionalBeanBuildItem.unremovableOf(KmsClientProducer.class);
    }

    @BuildStep
    void setup(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors, BuildProducer<AmazonClientBuildItem> clientProducer) {
        this.setupExtension(beanRegistrationPhase, extensionSslNativeSupport, feature, interceptors, clientProducer, this.buildTimeConfig.sdk, this.buildTimeConfig.syncClient);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupTransport(List<AmazonClientBuildItem> amazonClients, KmsRecorder recorder, AmazonClientTransportRecorder transportRecorder, KmsConfig runtimeConfig, BuildProducer<AmazonClientTransportsBuildItem> clientTransportBuildProducer) {
        this.createTransportBuilders(amazonClients, transportRecorder, this.buildTimeConfig.syncClient, recorder.getSyncConfig(runtimeConfig), recorder.getAsyncConfig(runtimeConfig), clientTransportBuildProducer);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createClientBuilders(List<AmazonClientTransportsBuildItem> transportBuildItems, KmsRecorder recorder, KmsConfig runtimeConfig, BuildProducer<AmazonClientBuilderBuildItem> builderProducer) {
        this.createClientBuilders(transportBuildItems, builderProducer, syncTransport -> recorder.createSyncBuilder(runtimeConfig, syncTransport), asyncTransport -> recorder.createAsyncBuilder(runtimeConfig, asyncTransport));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void configureClient(List<AmazonClientBuilderBuildItem> clients, KmsRecorder recorder, AmazonClientRecorder commonRecorder, KmsConfig runtimeConfig, BuildProducer<AmazonClientBuilderConfiguredBuildItem> producer) {
        this.initClientBuilders(clients, commonRecorder, recorder.getAwsConfig(runtimeConfig), recorder.getSdkConfig(runtimeConfig), this.buildTimeConfig.sdk, producer);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void buildClients(List<AmazonClientBuilderConfiguredBuildItem> configuredClients, KmsRecorder recorder, BeanContainerBuildItem beanContainer, ShutdownContextBuildItem shutdown) {
        this.buildClients(configuredClients, syncBuilder -> recorder.buildClient(syncBuilder, beanContainer.getValue(), (ShutdownContext)shutdown), asyncBuilder -> recorder.buildAsyncClient(asyncBuilder, beanContainer.getValue(), (ShutdownContext)shutdown));
    }
}

