/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.runtime;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.LambdaRuntime;
import com.fasterxml.jackson.databind.ObjectReader;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaApi;
import java.io.IOException;
import java.net.HttpURLConnection;

public class AmazonLambdaContext
implements Context {
    private String awsRequestId;
    private String logGroupName;
    private String logStreamName;
    private String functionName;
    private String functionVersion;
    private String invokedFunctionArn;
    private CognitoIdentity cognitoIdentity;
    private ClientContext clientContext;
    private long runtimeDeadlineMs = 0L;
    private int memoryLimitInMB;
    private LambdaLogger logger;

    public AmazonLambdaContext(HttpURLConnection request, ObjectReader cognitoReader, ObjectReader clientCtxReader) throws IOException {
        String functionMemorySize;
        String clientContextHeader;
        this.awsRequestId = request.getHeaderField("Lambda-Runtime-Aws-Request-Id");
        this.logGroupName = AmazonLambdaApi.logGroupName();
        this.logStreamName = AmazonLambdaApi.logStreamName();
        this.functionName = AmazonLambdaApi.functionName();
        this.functionVersion = AmazonLambdaApi.functionVersion();
        this.invokedFunctionArn = request.getHeaderField("Lambda-Runtime-Invoked-Function-Arn");
        String cognitoIdentityHeader = request.getHeaderField("Lambda-Runtime-Cognito-Identity");
        if (cognitoIdentityHeader != null) {
            this.cognitoIdentity = (CognitoIdentity)cognitoReader.readValue(cognitoIdentityHeader);
        }
        if ((clientContextHeader = request.getHeaderField("Lambda-Runtime-Client-Context")) != null) {
            this.clientContext = (ClientContext)clientCtxReader.readValue(clientContextHeader);
        }
        this.memoryLimitInMB = (functionMemorySize = AmazonLambdaApi.functionMemorySize()) != null ? Integer.valueOf(functionMemorySize) : 0;
        String runtimeDeadline = request.getHeaderField("Lambda-Runtime-Deadline-Ms");
        if (runtimeDeadline != null) {
            this.runtimeDeadlineMs = Long.valueOf(runtimeDeadline);
        }
        this.logger = LambdaRuntime.getLogger();
    }

    public String getAwsRequestId() {
        return this.awsRequestId;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public String getLogStreamName() {
        return this.logStreamName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getFunctionVersion() {
        return this.functionVersion;
    }

    public String getInvokedFunctionArn() {
        return this.invokedFunctionArn;
    }

    public CognitoIdentity getIdentity() {
        return this.cognitoIdentity;
    }

    public ClientContext getClientContext() {
        return this.clientContext;
    }

    public int getRemainingTimeInMillis() {
        return (int)(this.runtimeDeadlineMs - Math.round((double)System.nanoTime() / 1000000.0));
    }

    public int getMemoryLimitInMB() {
        return this.memoryLimitInMB;
    }

    public LambdaLogger getLogger() {
        return this.logger;
    }
}

