/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.runtime;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaApi;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaContext;
import io.quarkus.amazon.lambda.runtime.FunctionError;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;

@Recorder
public class AmazonLambdaRecorder {
    private static final Logger log = Logger.getLogger(AmazonLambdaRecorder.class);

    public void start(Class<? extends RequestHandler<?, ?>> handlerClass, ShutdownContext context, RuntimeValue<Class<?>> handlerType, BeanContainer beanContainer) {
        final RequestHandler handler = (RequestHandler)beanContainer.instance(handlerClass, new Annotation[0]);
        final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        final AtomicBoolean running = new AtomicBoolean(true);
        final ObjectReader objectReader = mapper.readerFor((Class)handlerType.getValue());
        final ObjectReader cognitoIdReader = mapper.readerFor(CognitoIdentity.class);
        final ObjectReader clientCtxReader = mapper.readerFor(ClientContext.class);
        context.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                running.set(false);
            }
        });
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    URL requestUrl = AmazonLambdaApi.invocationNext();
                    while (running.get()) {
                        HttpURLConnection requestConnection = (HttpURLConnection)requestUrl.openConnection();
                        try {
                            Object response;
                            String requestId = requestConnection.getHeaderField("Lambda-Runtime-Aws-Request-Id");
                            try {
                                Object val = objectReader.readValue(requestConnection.getInputStream());
                                response = handler.handleRequest(val, (Context)new AmazonLambdaContext(requestConnection, cognitoIdReader, clientCtxReader));
                            }
                            catch (Exception e) {
                                log.error((Object)"Failed to run lambda", (Throwable)e);
                                AmazonLambdaRecorder.this.postResponse(AmazonLambdaApi.invocationError(requestId), new FunctionError(e.getClass().getName(), e.getMessage()), mapper);
                                requestConnection.getInputStream().close();
                                continue;
                            }
                            AmazonLambdaRecorder.this.postResponse(AmazonLambdaApi.invocationResponse(requestId), response, mapper);
                        }
                        catch (Exception e) {
                            log.error((Object)"Error running lambda", (Throwable)e);
                            Application app = Application.currentApplication();
                            if (app != null) {
                                app.stop();
                            }
                            return;
                        }
                        finally {
                            requestConnection.getInputStream().close();
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        log.error((Object)"Lambda init error", (Throwable)e);
                        AmazonLambdaRecorder.this.postResponse(AmazonLambdaApi.initError(), new FunctionError(e.getClass().getName(), e.getMessage()), mapper);
                    }
                    catch (Exception ex) {
                        log.error((Object)"Failed to report init error", (Throwable)ex);
                    }
                    finally {
                        Application app = Application.currentApplication();
                        if (app != null) {
                            app.stop();
                        }
                    }
                }
            }
        }, "Lambda Thread");
        t.start();
    }

    private void postResponse(URL url, Object response, ObjectMapper mapper) throws IOException {
        HttpURLConnection responseConnection = (HttpURLConnection)url.openConnection();
        responseConnection.setDoOutput(true);
        responseConnection.setRequestMethod("POST");
        mapper.writeValue(responseConnection.getOutputStream(), response);
        while (responseConnection.getInputStream().read() != -1) {
        }
    }

    public RuntimeValue<Class<?>> discoverParameterTypes(Class<? extends RequestHandler<?, ?>> handlerClass) {
        Method[] methods = handlerClass.getMethods();
        Method method = null;
        for (int i = 0; i < methods.length && method == null; ++i) {
            Class<?>[] types;
            if (!methods[i].getName().equals("handleRequest") || (types = methods[i].getParameterTypes()).length != 2 || types[0].equals(Object.class)) continue;
            method = methods[i];
        }
        if (method == null) {
            method = methods[0];
        }
        return new RuntimeValue(method.getParameterTypes()[0]);
    }
}

