/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDeploymentValidatorBuildItem;
import io.quarkus.arc.deployment.ConfigPropertyBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.runtime.ConfigDeploymentTemplate;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.smallrye.config.inject.ConfigProducer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.builder.item.BuildItem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class ConfigBuildStep {
    private static final DotName CONFIG_PROPERTY_NAME = DotName.createSimple((String)ConfigProperty.class.getName());

    @BuildStep
    AdditionalBeanBuildItem bean() {
        return new AdditionalBeanBuildItem(ConfigProducer.class);
    }

    @BuildStep
    BeanDeploymentValidatorBuildItem collectMandatoryConfigProperties(final BuildProducer<ConfigPropertyBuildItem> configProperties) {
        return new BeanDeploymentValidatorBuildItem(new BeanDeploymentValidator(){

            public void validate(BeanDeploymentValidator.ValidationContext validationContext) {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                for (InjectionPointInfo injectionPoint : (List)validationContext.get(BuildExtension.Key.INJECTION_POINTS)) {
                    Class<Object> propertyType;
                    String propertyName;
                    block14: {
                        block13: {
                            AnnotationValue defaultValue;
                            AnnotationInstance configProperty;
                            if (injectionPoint.hasDefaultedQualifier() || DotNames.OPTIONAL.equals((Object)injectionPoint.getRequiredType().name()) || (configProperty = (AnnotationInstance)injectionPoint.getRequiredQualifiers().stream().filter(a -> a.name().equals((Object)CONFIG_PROPERTY_NAME)).findFirst().orElse(null)) == null || (defaultValue = configProperty.value("defaultValue")) != null && !"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue.asString())) continue;
                            propertyName = configProperty.value("name").asString();
                            if (injectionPoint.getRequiredType().kind() != Type.Kind.PRIMITIVE) break block13;
                            switch (injectionPoint.getRequiredType().asPrimitiveType().primitive()) {
                                case BOOLEAN: {
                                    propertyType = Boolean.TYPE;
                                    break block14;
                                }
                                case BYTE: {
                                    propertyType = Byte.TYPE;
                                    break block14;
                                }
                                case CHAR: {
                                    propertyType = Character.TYPE;
                                    break block14;
                                }
                                case DOUBLE: {
                                    propertyType = Double.TYPE;
                                    break block14;
                                }
                                case INT: {
                                    propertyType = Integer.TYPE;
                                    break block14;
                                }
                                case FLOAT: {
                                    propertyType = Float.TYPE;
                                    break block14;
                                }
                                case LONG: {
                                    propertyType = Long.TYPE;
                                    break block14;
                                }
                                case SHORT: {
                                    propertyType = Short.TYPE;
                                    break block14;
                                }
                                default: {
                                    throw new IllegalArgumentException("Not a supported primitive type: " + injectionPoint.getRequiredType().asPrimitiveType().primitive());
                                }
                            }
                        }
                        try {
                            propertyType = tccl.loadClass(injectionPoint.getRequiredType().name().toString());
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalStateException("Unable to load the config property type: " + injectionPoint, e);
                        }
                    }
                    configProperties.produce((BuildItem)new ConfigPropertyBuildItem(propertyName, propertyType));
                }
            }
        });
    }

    @BuildStep
    void annotationTransformer(BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) throws Exception {
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.FIELD;
            }

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                if (transformationContext.getTarget().asField().hasAnnotation(CONFIG_PROPERTY_NAME) && !transformationContext.getTarget().asField().hasAnnotation(DotNames.INJECT)) {
                    transformationContext.transform().add(Inject.class, new AnnotationValue[0]).done();
                }
            }
        }));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void validateConfigProperties(ConfigDeploymentTemplate template, List<ConfigPropertyBuildItem> configProperties, BeanContainerBuildItem beanContainer) {
        Map propNamesToClasses = configProperties.stream().collect(Collectors.groupingBy(ConfigPropertyBuildItem::getPropertyName, Collectors.mapping(ConfigPropertyBuildItem::getPropertyType, Collectors.toSet())));
        template.validateConfigProperties(propNamesToClasses);
    }
}

