/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.item.MultiBuildItem;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

public final class UnremovableBeanBuildItem
extends MultiBuildItem {
    private final Predicate<BeanInfo> predicate;

    public UnremovableBeanBuildItem(Predicate<BeanInfo> predicate) {
        this.predicate = predicate;
    }

    public Predicate<BeanInfo> getPredicate() {
        return this.predicate;
    }

    public static class BeanClassAnnotationExclusion
    implements Predicate<BeanInfo> {
        private final String nameStartsWith;
        private final DotName name;

        public BeanClassAnnotationExclusion(String nameStartsWith) {
            this.nameStartsWith = Objects.requireNonNull(nameStartsWith);
            this.name = null;
        }

        public BeanClassAnnotationExclusion(DotName name) {
            this.nameStartsWith = null;
            this.name = name;
        }

        @Override
        public boolean test(BeanInfo bean) {
            if (bean.isClassBean()) {
                Map annotations = ((AnnotationTarget)bean.getTarget().get()).asClass().annotations();
                if (this.name != null) {
                    return annotations.containsKey(this.name);
                }
                return annotations.keySet().stream().anyMatch(a -> a.toString().startsWith(this.nameStartsWith));
            }
            return false;
        }
    }

    public static class BeanTypesExclusion
    implements Predicate<BeanInfo> {
        private final Set<DotName> dotNames;

        public BeanTypesExclusion(Set<DotName> dotNames) {
            this.dotNames = Objects.requireNonNull(dotNames);
        }

        @Override
        public boolean test(BeanInfo bean) {
            return bean.getTypes().stream().anyMatch(t -> this.dotNames.contains(t.name()));
        }
    }

    public static class BeanTypeExclusion
    implements Predicate<BeanInfo> {
        private final DotName dotName;

        public BeanTypeExclusion(DotName dotName) {
            this.dotName = Objects.requireNonNull(dotName);
        }

        @Override
        public boolean test(BeanInfo bean) {
            return bean.getTypes().stream().anyMatch(t -> this.dotName.equals((Object)t.name()));
        }
    }

    public static class BeanClassNamesExclusion
    implements Predicate<BeanInfo> {
        private final Set<String> classNames;

        public BeanClassNamesExclusion(Set<String> classNames) {
            this.classNames = Objects.requireNonNull(classNames);
        }

        @Override
        public boolean test(BeanInfo bean) {
            return this.classNames.contains(bean.getBeanClass().toString());
        }
    }

    public static class BeanClassNameExclusion
    implements Predicate<BeanInfo> {
        private final String className;

        public BeanClassNameExclusion(String className) {
            this.className = Objects.requireNonNull(className);
        }

        @Override
        public boolean test(BeanInfo bean) {
            return bean.getBeanClass().toString().equals(this.className);
        }
    }
}

