/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.configproperties;

import io.quarkus.arc.deployment.configproperties.ConfigPropertyBuildItemCandidate;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ConfigPropertyBuildItemCandidateUtil {
    public static void removePropertiesWithDefaultValue(ClassLoader classLoader, String configClass, List<ConfigPropertyBuildItemCandidate> candidates) {
        try (InputStream is = classLoader.getResourceAsStream(configClass.replace('.', '/') + ".class");){
            ClassReader configClassReader = new ClassReader(is);
            configClassReader.accept((ClassVisitor)new ConfigClassVisitor(candidates), 0);
        }
        catch (IOException e) {
            throw new UncheckedIOException(configClass + " class reading failed", e);
        }
    }

    private static class ConfigClassConstructorVisitor
    extends MethodVisitor {
        private List<ConfigPropertyBuildItemCandidate> candidates;

        private ConfigClassConstructorVisitor(MethodVisitor superMethodVisitor, List<ConfigPropertyBuildItemCandidate> candidates) {
            super(524288, superMethodVisitor);
            this.candidates = candidates;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            if (opcode == 181) {
                this.candidates.removeIf(candidate -> candidate.getFieldName().equals(name));
            }
            super.visitFieldInsn(opcode, owner, name, descriptor);
        }
    }

    private static class ConfigClassVisitor
    extends ClassVisitor {
        private List<ConfigPropertyBuildItemCandidate> candidates;

        private ConfigClassVisitor(List<ConfigPropertyBuildItemCandidate> candidates) {
            super(524288);
            this.candidates = candidates;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor superMethodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (access == 1 && name.equals("<init>") && descriptor.equals("()V")) {
                return new ConfigClassConstructorVisitor(superMethodVisitor, this.candidates);
            }
            return superMethodVisitor;
        }
    }
}

