/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.caffeine.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.io.IOException;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class CaffeineProcessor {
    private static final String CACHE_LOADER_CLASS_NAME = "com.github.benmanes.caffeine.cache.CacheLoader";
    private static final DotName CACHE_LOADER_NAME = DotName.createSimple((String)"com.github.benmanes.caffeine.cache.CacheLoader");

    @BuildStep
    ReflectiveClassBuildItem cacheClasses() throws IOException {
        return new ReflectiveClassBuildItem(false, false, new String[]{"com.github.benmanes.caffeine.cache.SSLMS", "com.github.benmanes.caffeine.cache.SILMS", "com.github.benmanes.caffeine.cache.PSMS", "com.github.benmanes.caffeine.cache.PDMS", "com.github.benmanes.caffeine.cache.SSMS", "com.github.benmanes.caffeine.cache.SSLA", "com.github.benmanes.caffeine.cache.PSA", "com.github.benmanes.caffeine.cache.SSMSW", "com.github.benmanes.caffeine.cache.PSWMW", "com.github.benmanes.caffeine.cache.SSW", "com.github.benmanes.caffeine.cache.PSW"});
    }

    @BuildStep
    void cacheLoaders(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{CACHE_LOADER_CLASS_NAME}));
        for (ClassInfo info : combinedIndex.getIndex().getAllKnownImplementors(CACHE_LOADER_NAME)) {
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{info.name().toString()}));
        }
    }
}

