/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import io.quarkus.cli.common.PropertiesOptions;
import io.quarkus.cli.common.TargetQuarkusVersionGroup;
import io.quarkus.cli.create.BaseCreateCommand;
import io.quarkus.cli.create.CodeGenerationGroup;
import io.quarkus.cli.create.CreateProjectMixin;
import io.quarkus.cli.create.TargetBuildToolGroup;
import io.quarkus.cli.create.TargetGAVGroup;
import io.quarkus.cli.create.TargetLanguageGroup;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.handlers.CreateJBangProjectCommandHandler;
import io.quarkus.devtools.commands.handlers.CreateProjectCommandHandler;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.codegen.SourceType;
import java.util.HashSet;
import java.util.Set;
import picocli.CommandLine;

@CommandLine.Command(name="cli", sortOptions=false, showDefaultValues=true, mixinStandardHelpOptions=false, header={"Create a Quarkus command-line project."}, description={"%nThis command will create a Java project in a new ARTIFACT-ID directory."}, footer={"%nFor example (using default values), a new Java project will be created in a 'code-with-quarkus' directory; it will use Maven to build an artifact with GROUP-ID='org.acme', ARTIFACT-ID='code-with-quarkus', and VERSION='1.0.0-SNAPSHOT'.%n"}, headerHeading="%n", commandListHeading="%nCommands:%n", synopsisHeading="%nUsage: ", parameterListHeading="%n", optionListHeading="Options:%n")
public class CreateCli
extends BaseCreateCommand {
    @CommandLine.Mixin
    CreateProjectMixin createProject;
    @CommandLine.Mixin
    TargetGAVGroup gav = new TargetGAVGroup();
    @CommandLine.Option(order=1, paramLabel="EXTENSION", names={"-x", "--extension"}, description={"Extension(s) to add to the project."}, split=",")
    Set<String> extensions = new HashSet<String>();
    @CommandLine.ArgGroup(order=2, heading="%nQuarkus version:%n")
    TargetQuarkusVersionGroup targetQuarkusVersion = new TargetQuarkusVersionGroup();
    @CommandLine.ArgGroup(order=3, heading="%nBuild tool (Maven):%n")
    TargetBuildToolGroup targetBuildTool = new TargetBuildToolGroup();
    @CommandLine.ArgGroup(order=4, heading="%nTarget language (Java):%n")
    TargetLanguageGroup targetLanguage = new TargetLanguageGroup();
    @CommandLine.ArgGroup(order=5, exclusive=false, heading="%nCode Generation:%n")
    CodeGenerationGroup codeGeneration = new CodeGenerationGroup();
    @CommandLine.ArgGroup(order=6, exclusive=false, validate=false)
    PropertiesOptions propertiesOptions = new PropertiesOptions();

    @Override
    public Integer call() throws Exception {
        try {
            this.output.debug("Creating a new project with initial parameters: %s", new Object[]{this});
            this.output.throwIfUnmatchedArguments(this.spec.commandLine());
            this.extensions.add("picocli");
            this.createProject.setSingleProjectGAV(this.gav);
            this.createProject.setTestOutputDirectory(this.output.getTestDirectory());
            if (this.createProject.checkProjectRootAlreadyExists(this.output, false)) {
                return 2;
            }
            BuildTool buildTool = this.targetBuildTool.getBuildTool(BuildTool.MAVEN);
            SourceType sourceType = this.targetLanguage.getSourceType(buildTool, this.extensions, this.output);
            this.createProject.setSourceTypeExtensions(this.extensions, sourceType);
            this.createProject.setCodegenOptions(this.codeGeneration);
            QuarkusCommandInvocation invocation = this.createProject.build(buildTool, this.targetQuarkusVersion, this.output, this.propertiesOptions.properties);
            boolean success = true;
            if (this.runMode.isDryRun()) {
                this.createProject.dryRun(buildTool, invocation, this.output);
            } else {
                success = BuildTool.JBANG.equals((Object)buildTool) ? new CreateJBangProjectCommandHandler().execute(invocation).isSuccess() : new CreateProjectCommandHandler().execute(invocation).isSuccess();
            }
            if (success) {
                this.output.info("Navigate into this directory and get started: " + this.spec.root().qualifiedName() + " dev");
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            return this.output.handleCommandException(e, "Unable to create project: " + e.getMessage());
        }
    }

    public String toString() {
        return "CreateCli{gav=" + this.gav + ", quarkusVersion=" + this.targetQuarkusVersion + ", targetBuildTool=" + this.targetBuildTool + ", targetLanguage=" + this.targetLanguage + ", codeGeneration=" + this.codeGeneration + ", extensions=" + this.extensions + ", project=" + this.createProject + ", properties=" + this.propertiesOptions.properties + "}";
    }
}

