/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import io.quarkus.cli.registry.BaseRegistryCommand;
import io.quarkus.cli.registry.RegistryClientMixin;
import io.quarkus.registry.ExtensionCatalogResolver;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.config.RegistriesConfigLocator;
import io.quarkus.registry.config.RegistryConfig;
import java.nio.file.Path;
import picocli.CommandLine;

@CommandLine.Command(name="list", sortOptions=false, showDefaultValues=true, mixinStandardHelpOptions=false, header={"List enabled Quarkus registries"}, description={"%nThis command will list currently enabled Quarkus extension registries"}, headerHeading="%n", commandListHeading="%nCommands:%n", synopsisHeading="%nUsage: ", parameterListHeading="%n", optionListHeading="Options:%n")
public class RegistryListCommand
extends BaseRegistryCommand {
    @CommandLine.Mixin
    protected RegistryClientMixin registryClient;
    @CommandLine.Option(names={"--streams"}, description={"List currently recommended platform streams"}, defaultValue="false")
    boolean streams;

    @Override
    public Integer call() throws Exception {
        ExtensionCatalogResolver catalogResolver;
        this.registryClient.refreshRegistryCache(this.output);
        RegistriesConfig config = RegistriesConfigLocator.resolveConfig();
        ExtensionCatalogResolver extensionCatalogResolver = catalogResolver = this.streams ? this.registryClient.getExtensionCatalogResolver(this.output) : null;
        if (this.streams) {
            this.output.info("Available Quarkus platform streams per registry:");
        } else {
            this.output.info("Configured Quarkus extension registries:");
        }
        for (RegistryConfig r : config.getRegistries()) {
            if (r.isEnabled()) {
                PlatformCatalog platformCatalog;
                this.output.info(r.getId());
                if (catalogResolver == null || (platformCatalog = catalogResolver.resolvePlatformCatalogFromRegistry(r.getId())) == null) continue;
                for (Platform p : platformCatalog.getPlatforms()) {
                    for (PlatformStream s : p.getStreams()) {
                        this.output.info("  " + p.getPlatformKey() + ":" + s.getId());
                    }
                }
                continue;
            }
            this.output.info(r.getId() + " (disabled)");
        }
        Path configYaml = RegistriesConfigLocator.locateConfigYaml();
        if (configYaml != null) {
            this.output.info("(Read from " + configYaml + ")");
        }
        return 0;
    }
}

