/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import io.quarkus.cli.common.HelpOption;
import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.PropertiesOptions;
import io.smallrye.common.classloader.ClassPathUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Properties;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="version", sortOptions=false, header={"Display version information."}, headerHeading="%n", commandListHeading="%nCommands:%n", synopsisHeading="%nUsage: ", optionListHeading="Options:%n")
public class Version
implements CommandLine.IVersionProvider,
Callable<Integer> {
    private static String version;
    @CommandLine.Mixin
    OutputOptionMixin output;
    @CommandLine.Mixin
    HelpOption helpOption;
    @CommandLine.ArgGroup(exclusive=false, validate=false)
    protected PropertiesOptions propertiesOptions = new PropertiesOptions();
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(order=3, names={"--dependencies"}, description={"Show project dependency versions"})
    boolean dependencies = false;

    @Override
    public Integer call() throws Exception {
        this.output.printText(this.getVersion());
        return 0;
    }

    public String[] getVersion() throws Exception {
        return new String[]{"Client Version " + Version.clientVersion()};
    }

    public static String clientVersion() {
        if (version != null) {
            return version;
        }
        Properties props = new Properties();
        URL quarkusPropertiesUrl = Thread.currentThread().getContextClassLoader().getResource("quarkus.properties");
        if (quarkusPropertiesUrl == null) {
            throw new RuntimeException("Failed to locate quarkus.properties on the classpath");
        }
        if ("file".equals(quarkusPropertiesUrl.getProtocol()) || "jar".equals(quarkusPropertiesUrl.getProtocol())) {
            ClassPathUtils.consumeAsPath((URL)quarkusPropertiesUrl, p -> {
                try (BufferedReader reader = Files.newBufferedReader(p);){
                    props.load(reader);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load quarkus.properties", e);
                }
            });
        } else {
            try {
                props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("quarkus.properties"));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load quarkus.properties", e);
            }
        }
        version = props.getProperty("quarkus-core-version");
        if (version == null) {
            throw new RuntimeException("Failed to locate quarkus-core-version property in the bundled quarkus.properties");
        }
        return version;
    }
}

