/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.build;

import io.quarkus.cli.build.ExecuteUtil;
import io.quarkus.cli.build.GradleRunner;
import io.quarkus.cli.build.JBangRunner;
import io.quarkus.cli.build.MavenRunner;
import io.quarkus.cli.common.BuildOptions;
import io.quarkus.cli.common.CategoryListFormatOptions;
import io.quarkus.cli.common.DebugOptions;
import io.quarkus.cli.common.DevOptions;
import io.quarkus.cli.common.ListFormatOptions;
import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.PropertiesOptions;
import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.registry.RegistryClientMixin;
import io.quarkus.devtools.project.BuildTool;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public interface BuildSystemRunner {
    public static BuildSystemRunner getRunner(OutputOptionMixin output, PropertiesOptions propertiesOptions, RegistryClientMixin registryClient, Path projectRoot, BuildTool buildTool) {
        if (buildTool == null) {
            throw new IllegalStateException("Is this a project directory? Unable to find a build file in: " + projectRoot);
        }
        switch (buildTool) {
            default: {
                return new MavenRunner(output, propertiesOptions, registryClient, projectRoot);
            }
            case GRADLE_KOTLIN_DSL: {
                return new GradleRunner(output, propertiesOptions, registryClient, projectRoot, BuildTool.GRADLE_KOTLIN_DSL);
            }
            case GRADLE: {
                return new GradleRunner(output, propertiesOptions, registryClient, projectRoot, BuildTool.GRADLE);
            }
            case JBANG: 
        }
        return new JBangRunner(output, propertiesOptions, registryClient, projectRoot);
    }

    default public int run(BuildCommandArgs command) {
        try {
            return ExecuteUtil.executeProcess(this.getOutput(), command.arguments, command.targetDirectory);
        }
        catch (IOException | InterruptedException e) {
            this.getOutput().error("Command failed. " + e.getMessage());
            this.getOutput().printStackTrace(e);
            return 1;
        }
    }

    default public BuildCommandArgs prependExecutable(ArrayDeque<String> args) {
        BuildCommandArgs cmd = new BuildCommandArgs();
        File wrapper = this.getWrapper();
        if (wrapper != null) {
            args.addFirst(wrapper.getAbsolutePath());
            cmd.targetDirectory = wrapper.getParentFile();
        } else {
            File command = this.getExecutable();
            args.addFirst(command.getAbsolutePath());
            cmd.targetDirectory = this.getProjectRoot().toFile();
        }
        cmd.arguments = args.toArray(new String[0]);
        return cmd;
    }

    default public void paramsToQuarkusArgs(List<String> params, ArrayDeque<String> args) {
        if (!params.isEmpty()) {
            args.add("-Dquarkus.args='" + String.join((CharSequence)" ", params) + "'");
        }
    }

    default public List<String> flattenMappedProperties(Map<String, String> props) {
        ArrayList<String> result = new ArrayList<String>();
        props.entrySet().forEach(x -> {
            if (((String)x.getValue()).length() > 0) {
                result.add("-D" + (String)x.getKey() + "=" + (String)x.getValue());
            } else {
                result.add("-D" + (String)x.getKey());
            }
        });
        return result;
    }

    default public String fixPath(Path absolutePath) {
        return this.getProjectRoot().relativize(absolutePath).toString();
    }

    public Integer listExtensionCategories(RunModeOption var1, CategoryListFormatOptions var2) throws Exception;

    public Integer listExtensions(RunModeOption var1, ListFormatOptions var2, boolean var3, String var4, String var5) throws Exception;

    public Integer addExtension(RunModeOption var1, Set<String> var2) throws Exception;

    public Integer removeExtension(RunModeOption var1, Set<String> var2) throws Exception;

    public BuildCommandArgs prepareBuild(BuildOptions var1, RunModeOption var2, List<String> var3);

    public List<Supplier<BuildCommandArgs>> prepareDevMode(DevOptions var1, DebugOptions var2, List<String> var3);

    public Path getProjectRoot();

    public File getExecutable();

    public File getWrapper();

    public OutputOptionMixin getOutput();

    public BuildTool getBuildTool();

    public static class BuildCommandArgs {
        String[] arguments;
        File targetDirectory;

        public String showCommand() {
            return String.join((CharSequence)" ", this.arguments);
        }

        public String toString() {
            return "BuildCommandArgs{arguments=" + Arrays.toString(this.arguments) + ", targetDirectory=" + this.targetDirectory + "}";
        }
    }
}

