/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.build;

import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.utilities.OS;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class ExecuteUtil {
    public static File findExecutableFile(String base) {
        String path = null;
        Object executable = base;
        if (OS.determineOS() == OS.WINDOWS) {
            executable = base + ".cmd";
            path = ExecuteUtil.findExecutable((String)executable);
            if (path == null) {
                executable = base + ".bat";
                path = ExecuteUtil.findExecutable((String)executable);
            }
        } else {
            executable = base;
            path = ExecuteUtil.findExecutable((String)executable);
        }
        if (path == null) {
            return null;
        }
        return new File(path, (String)executable);
    }

    private static String findExecutable(String exec) {
        return Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator))).map(x$0 -> Paths.get(x$0, new String[0])).map(path -> path.resolve(exec).toFile()).filter(File::exists).findFirst().map(File::getParent).orElse(null);
    }

    public static File findExecutable(String name, String errorMessage, OutputOptionMixin output) {
        File command = ExecuteUtil.findExecutableFile(name);
        if (command == null) {
            output.error(errorMessage);
            throw new RuntimeException("Unable to find " + name + " command");
        }
        return command;
    }

    public static int executeProcess(OutputOptionMixin output, String[] args, File parentDir) throws IOException, InterruptedException {
        if (output.isVerbose()) {
            output.out().println(String.join((CharSequence)" ", args));
            output.out().println();
        }
        int exit = 1;
        if (output.isCliTest()) {
            Process process = new ProcessBuilder(new String[0]).command(args).redirectInput(ProcessBuilder.Redirect.INHERIT).directory(parentDir).start();
            ExecutorService service = Executors.newFixedThreadPool(2);
            service.submit(() -> new BufferedReader(new InputStreamReader(process.getInputStream())).lines().forEach(output.out()::println));
            service.submit(() -> new BufferedReader(new InputStreamReader(process.getErrorStream())).lines().forEach(output.err()::println));
            process.waitFor(5L, TimeUnit.MINUTES);
            service.shutdown();
            exit = process.exitValue();
        } else {
            Process process = new ProcessBuilder(new String[0]).command(args).inheritIO().directory(parentDir).start();
            exit = process.waitFor();
        }
        if (exit != 0) {
            return 1;
        }
        return 0;
    }

    public static File findWrapper(Path projectRoot, String[] windows, String other) {
        if (OS.determineOS() == OS.WINDOWS) {
            for (String name : windows) {
                File wrapper = new File(projectRoot + File.separator + name);
                if (!wrapper.isFile()) continue;
                return wrapper;
            }
        } else {
            File wrapper = new File(projectRoot + File.separator + other);
            if (wrapper.isFile()) {
                return wrapper;
            }
        }
        return null;
    }
}

