/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.build;

import io.quarkus.cli.build.BuildSystemRunner;
import io.quarkus.cli.build.ExecuteUtil;
import io.quarkus.cli.common.BuildOptions;
import io.quarkus.cli.common.CategoryListFormatOptions;
import io.quarkus.cli.common.DebugOptions;
import io.quarkus.cli.common.DevOptions;
import io.quarkus.cli.common.ListFormatOptions;
import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.PropertiesOptions;
import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.registry.RegistryClientMixin;
import io.quarkus.devtools.project.BuildTool;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class GradleRunner
implements BuildSystemRunner {
    public static final String[] windowsWrapper = new String[]{"gradlew.cmd", "gradlew.bat"};
    public static final String otherWrapper = "gradlew";
    final OutputOptionMixin output;
    final RegistryClientMixin registryClient;
    final Path projectRoot;
    final BuildTool buildTool;
    final PropertiesOptions propertiesOptions;

    public GradleRunner(OutputOptionMixin output, PropertiesOptions propertiesOptions, RegistryClientMixin registryClient, Path projectRoot, BuildTool buildTool) {
        this.output = output;
        this.projectRoot = projectRoot;
        this.buildTool = buildTool;
        this.propertiesOptions = propertiesOptions;
        this.registryClient = registryClient;
        this.verifyBuildFile();
    }

    @Override
    public File getWrapper() {
        return ExecuteUtil.findWrapper(this.projectRoot, windowsWrapper, otherWrapper);
    }

    @Override
    public File getExecutable() {
        return ExecuteUtil.findExecutable("gradle", "Unable to find the gradle executable, is it in your path?", this.output);
    }

    @Override
    public Path getProjectRoot() {
        return this.projectRoot;
    }

    @Override
    public OutputOptionMixin getOutput() {
        return this.output;
    }

    @Override
    public BuildTool getBuildTool() {
        return this.buildTool;
    }

    @Override
    public Integer listExtensionCategories(RunModeOption runMode, CategoryListFormatOptions format) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        this.setGradleProperties(args, runMode.isBatchMode());
        args.add("listCategories");
        args.add("--fromCli");
        args.add("--format=" + format.getFormatString());
        return this.run(this.prependExecutable(args));
    }

    @Override
    public Integer listExtensions(RunModeOption runMode, ListFormatOptions format, boolean installable, String searchPattern, String category) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        this.setGradleProperties(args, runMode.isBatchMode());
        args.add("listExtensions");
        args.add("--fromCli");
        args.add("--format=" + format.getFormatString());
        if (category != null && !category.isBlank()) {
            args.add("--category=" + category);
        }
        if (!installable) {
            args.add("--installed");
        }
        if (searchPattern != null) {
            args.add("--searchPattern=" + searchPattern);
        }
        return this.run(this.prependExecutable(args));
    }

    @Override
    public Integer addExtension(RunModeOption runMode, Set<String> extensions) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        this.setGradleProperties(args, runMode.isBatchMode());
        args.add("addExtension");
        String param = "--extensions=" + String.join((CharSequence)",", extensions);
        args.add(param);
        return this.run(this.prependExecutable(args));
    }

    @Override
    public Integer removeExtension(RunModeOption runMode, Set<String> extensions) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        this.setGradleProperties(args, runMode.isBatchMode());
        args.add("removeExtension");
        String param = "--extensions=" + String.join((CharSequence)",", extensions);
        args.add(param);
        return this.run(this.prependExecutable(args));
    }

    @Override
    public BuildSystemRunner.BuildCommandArgs prepareBuild(BuildOptions buildOptions, RunModeOption runMode, List<String> params) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        this.setGradleProperties(args, runMode.isBatchMode());
        if (buildOptions.clean) {
            args.add("clean");
        }
        args.add("build");
        if (buildOptions.buildNative) {
            args.add("-Dquarkus.package.type=native");
        }
        if (buildOptions.skipTests()) {
            this.setSkipTests(args);
        }
        if (buildOptions.offline) {
            args.add("--offline");
        }
        args.addAll(params);
        return this.prependExecutable(args);
    }

    @Override
    public List<Supplier<BuildSystemRunner.BuildCommandArgs>> prepareDevMode(DevOptions devOptions, DebugOptions debugOptions, List<String> params) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        ArrayList<String> jvmArgs = new ArrayList<String>();
        this.setGradleProperties(args, false);
        if (devOptions.clean) {
            args.add("clean");
        }
        args.add("quarkusDev");
        if (devOptions.skipTests()) {
            this.setSkipTests(args);
        }
        debugOptions.addDebugArguments(args, jvmArgs);
        this.propertiesOptions.flattenJvmArgs(jvmArgs, args);
        this.paramsToQuarkusArgs(params, args);
        try {
            final Path outputFile = Files.createTempFile("quarkus-dev", ".txt", new FileAttribute[0]);
            args.add("-Dio.quarkus.devmode-args=" + outputFile.toAbsolutePath().toString());
            final BuildSystemRunner.BuildCommandArgs buildCommandArgs = this.prependExecutable(args);
            return Arrays.asList(new Supplier<BuildSystemRunner.BuildCommandArgs>(){

                @Override
                public BuildSystemRunner.BuildCommandArgs get() {
                    return buildCommandArgs;
                }
            }, new Supplier<BuildSystemRunner.BuildCommandArgs>(){

                @Override
                public BuildSystemRunner.BuildCommandArgs get() {
                    try {
                        List<String> lines = Files.readAllLines(outputFile).stream().filter(s -> !s.isBlank()).collect(Collectors.toList());
                        BuildSystemRunner.BuildCommandArgs cmd = new BuildSystemRunner.BuildCommandArgs();
                        cmd.arguments = lines.toArray(new String[0]);
                        cmd.targetDirectory = buildCommandArgs.targetDirectory;
                        return cmd;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void setSkipTests(ArrayDeque<String> args) {
        args.add("-x");
        args.add("test");
    }

    void setGradleProperties(ArrayDeque<String> args, boolean batchMode) {
        if (this.output.isShowErrors()) {
            args.add("--full-stacktrace");
        }
        if (batchMode) {
            args.add("--console=plain");
        } else if (this.output.isAnsiEnabled()) {
            args.add("--console=rich");
        }
        if (this.output.isCliTest()) {
            args.add("--project-dir=" + this.projectRoot.toAbsolutePath());
        }
        args.add(this.registryClient.getRegistryClientProperty());
        String configFile = System.getProperty("quarkus.tools.config");
        if (configFile != null) {
            args.add("-Dquarkus.tools.config=" + configFile);
        }
        args.addAll(this.flattenMappedProperties(this.propertiesOptions.properties));
    }

    void verifyBuildFile() {
        for (String buildFileName : this.buildTool.getBuildFiles()) {
            File buildFile = this.projectRoot.resolve(buildFileName).toFile();
            if (!buildFile.exists()) continue;
            return;
        }
        throw new IllegalStateException("Was not able to find a build file in: " + this.projectRoot + " based on the following list: " + String.join((CharSequence)",", this.buildTool.getBuildFiles()));
    }
}

