/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.create;

import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.TargetQuarkusVersionGroup;
import io.quarkus.cli.create.CodeGenerationGroup;
import io.quarkus.cli.create.TargetGAVGroup;
import io.quarkus.cli.registry.ToggleRegistryClientMixin;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.codegen.CreateProjectHelper;
import io.quarkus.devtools.project.codegen.SourceType;
import io.quarkus.registry.RegistryResolutionException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import picocli.CommandLine;

public class CreateProjectMixin {
    Map<String, Object> values = new HashMap<String, Object>();
    Path outputPath;
    Path projectRootPath;
    String projectDirName;
    @CommandLine.Spec(value=CommandLine.Spec.Target.MIXEE)
    CommandLine.Model.CommandSpec mixee;
    @CommandLine.Option(paramLabel="OUTPUT-DIR", names={"-o", "--output-directory"}, description={"The directory to create the new project in."})
    String targetDirectory;
    @CommandLine.Mixin
    ToggleRegistryClientMixin registryClient;

    public void setTestOutputDirectory(Path testOutputDirectory) {
        if (testOutputDirectory != null && this.targetDirectory == null) {
            this.outputPath = testOutputDirectory;
        }
    }

    public Path outputDirectory() {
        if (this.outputPath == null) {
            this.outputPath = CreateProjectHelper.createOutputDirectory((String)this.targetDirectory);
        }
        return this.outputPath;
    }

    public boolean checkProjectRootAlreadyExists(OutputOptionMixin log, boolean dryRun) {
        if (this.projectRootPath == null) {
            try {
                this.projectRootPath = CreateProjectHelper.checkProjectRootPath((Path)this.outputDirectory(), (String)this.projectDirName, (boolean)dryRun);
                return false;
            }
            catch (IllegalArgumentException iex) {
                if (dryRun) {
                    log.warn("A directory named '" + this.projectDirName + "' already exists.");
                    this.projectRootPath = this.outputDirectory().resolve(this.projectDirName);
                }
                log.error(iex.getMessage());
                log.out().printf("Specify a different artifactId / directory name.%n", new Object[0]);
                log.out().printf("See '%s --help' for more information.%n", this.mixee.qualifiedName());
                return true;
            }
        }
        return false;
    }

    public Path projectRoot() {
        if (this.projectRootPath == null) {
            this.projectRootPath = CreateProjectHelper.checkProjectRootPath((Path)this.outputDirectory(), (String)this.projectDirName, (boolean)false);
        }
        return this.projectRootPath;
    }

    public void setSourceTypeExtensions(Set<String> extensions, SourceType sourceType) {
        extensions = CreateProjectHelper.sanitizeExtensions(extensions);
        CreateProjectHelper.addSourceTypeExtensions((Set)extensions, (SourceType)sourceType);
        this.setValue("source_type", sourceType);
        this.setValue("extensions", extensions);
    }

    public void setSingleProjectGAV(TargetGAVGroup targetGav) {
        this.projectDirName = targetGav.getArtifactId();
        this.setValue("project_groupId", targetGav.getGroupId());
        this.setValue("project_artifactId", targetGav.getArtifactId());
        this.setValue("project_version", targetGav.getVersion());
    }

    public void setCodegenOptions(CodeGenerationGroup codeGeneration) {
        this.setValue("package_name", codeGeneration.packageName);
        this.setValue("app-config", codeGeneration.getAppConfig());
        this.setValue("quarkus.create-project.no-code", !codeGeneration.includeCode);
        this.setValue("quarkus.create-project.no-buildtool-wrapper", !codeGeneration.includeWrapper);
    }

    public void setValue(String name, Object value) {
        if (value != null) {
            this.values.put(name, value);
        }
    }

    public QuarkusCommandInvocation build(BuildTool buildTool, TargetQuarkusVersionGroup targetVersion, OutputOptionMixin log, Map<String, String> properties) throws RegistryResolutionException {
        CreateProjectHelper.setJavaVersion(this.values, null);
        CreateProjectHelper.handleSpringConfiguration(this.values);
        log.debug("Creating an app using the following settings: %s", new Object[]{this.values});
        QuarkusProject qp = this.registryClient.createQuarkusProject(this.projectRoot(), targetVersion, buildTool, log);
        properties.entrySet().forEach(x -> {
            if (((String)x.getValue()).length() > 0) {
                System.setProperty((String)x.getKey(), (String)x.getValue());
                log.info("property: %s=%s", new Object[]{x.getKey(), x.getValue()});
            } else {
                System.setProperty((String)x.getKey(), "");
                log.info("property: %s", new Object[]{x.getKey()});
            }
        });
        return new QuarkusCommandInvocation(qp, this.values);
    }

    public String toString() {
        return "CreateProjectMixin [outputPath=" + this.outputPath + ", registryClient" + this.registryClient + ", projectDirName=" + this.projectDirName + ", projectRootPath=" + this.projectRootPath + ", targetDirectory=" + this.targetDirectory + ", values=" + this.values + "]";
    }

    public void dryRun(BuildTool buildTool, QuarkusCommandInvocation invocation, OutputOptionMixin output) {
        CommandLine.Help help = this.mixee.commandLine().getHelp();
        output.printText(new String[]{"\nA new project would have been created in", "\t" + this.projectRoot().toString(), "\nThe project would have been created using the following settings:\n"});
        TreeMap<String, String> dryRunOutput = new TreeMap<String, String>();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            dryRunOutput.put(this.prettyName(entry.getKey()), entry.getValue().toString());
        }
        dryRunOutput.put("Quarkus Core Version", invocation.getExtensionsCatalog().getQuarkusCoreVersion());
        dryRunOutput.put("Build tool", buildTool == null ? "JBang" : buildTool.name());
        output.info(help.createTextTable(dryRunOutput).toString());
    }

    String prettyName(String key) {
        if ("quarkus.create-project.no-buildtool-wrapper".equals(key)) {
            return "Omit build tool wrapper";
        }
        key = ((String)key).substring(0, 1).toUpperCase() + ((String)key).substring(1);
        StringBuilder builder = new StringBuilder((String)key);
        for (int i = 0; i < builder.length(); ++i) {
            if (builder.charAt(i) != '_') continue;
            builder.replace(i, i + 1, " ");
            builder.replace(i + 1, i + 2, String.valueOf(Character.toUpperCase(builder.charAt(i + 1))));
        }
        return builder.toString();
    }
}

