/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.create;

import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.codegen.CreateProjectHelper;
import io.quarkus.devtools.project.codegen.SourceType;
import java.util.Set;
import picocli.CommandLine;

public class TargetLanguageGroup {
    SourceType sourceType;
    @CommandLine.Option(names={"--java"}, description={"Use Java"})
    boolean java = false;
    @CommandLine.Option(names={"--kotlin"}, description={"Use Kotlin"})
    boolean kotlin = false;
    @CommandLine.Option(names={"--scala"}, description={"Use Scala"})
    boolean scala = false;

    public SourceType getSourceType(BuildTool buildTool, Set<String> extensions, OutputOptionMixin output) {
        if (this.sourceType == null) {
            if (buildTool == null) {
                this.sourceType = SourceType.JAVA;
                if (this.kotlin || this.scala) {
                    output.warn("JBang only supports Java. Using Java as the target language.");
                }
            } else {
                this.sourceType = this.kotlin || BuildTool.GRADLE_KOTLIN_DSL == buildTool ? SourceType.KOTLIN : (this.scala ? SourceType.SCALA : CreateProjectHelper.determineSourceType(extensions));
            }
        }
        return this.sourceType;
    }

    public String toString() {
        return "TargetLanguageGroup [java=" + this.java + ", kotlin=" + this.kotlin + ", scala=" + this.scala + ", sourceType=" + this.sourceType + "]";
    }
}

