/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.PropertiesOptions;
import io.quarkus.cli.common.TargetQuarkusVersionGroup;
import io.quarkus.cli.create.BaseCreateCommand;
import io.quarkus.cli.create.ExtensionCodeGenerationGroup;
import io.quarkus.cli.create.ExtensionGAVMixin;
import io.quarkus.cli.create.ExtensionNameGenerationGroup;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.CreateExtensionCommandHandler;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.util.Map;
import java.util.TreeMap;
import picocli.CommandLine;

@CommandLine.Command(name="extension", header={"Create a Quarkus extension project"}, description={"%nQuarkus extensions are built from multiple modules: runtime, deployment, integration-test and docs. This command will generate a Maven multi-module project in a directory called EXTENSION-ID by applying naming conventions to the specified EXTENSION-ID."}, footer={"%nDefault Naming conventions%n", " GROUP-ID: io.quarkiverse.<EXTENSION-ID>", " EXTENSION-NAME: EXTENSION-ID converted to Capitalized Words", " NAMESPACE-NAME: NAMESPACE-ID converted to Capitalized Words", "%nModule Naming Conventions%n", " parent: ", "    artifactId:\t[NAMESPACE-ID][EXTENSION-ID]-parent", "    name:\t[NAMESPACE-NAME][EXTENSION-NAME] - Parent", " runtime:", "    artifactId:\t[NAMESPACE-ID][EXTENSION-ID]", "    name:\t[NAMESPACE-NAME][EXTENSION-NAME] - Runtime", " deployment:", "    artifactId:\t[NAMESPACE-ID][EXTENSION-ID]-deployment", "    name:\t[NAMESPACE-NAME][EXTENSION-NAME] - Deployment", " integration-tests:", "    artifactId:\t[NAMESPACE-ID][EXTENSION-ID]-integration-tests", "    name:\t[NAMESPACE-NAME][EXTENSION-NAME] - Integration Tests", " docs:", "    artifactId:\t[NAMESPACE-ID][EXTENSION-ID]-docs", "    name:\t[NAMESPACE-NAME][EXTENSION-NAME] - Documentation", "%nPackage and Class Naming Conventions%n", " Package name: [GROUP-ID][EXTENSION-ID] with any dashes replaced by dots", " Class name prefix: EXTENSION-ID converted to CamelCase", "%nAs an example, specifying 'hello-world' as the EXTENSION-ID and 'org.acme' as the GROUP-ID will generate a project containing the following modules:%n", "  hello-world: ", "    artifact:\torg.acme:hello-world-parent:1.0.0-SNAPSHOT", "    name:\tHello World - Parent", "  hello-world/runtime:", "    artifact:\torg.acme:hello-world:1.0.0-SNAPSHOT", "    name:\tHello World - Runtime", "    package name: org.acme.hello.world.runtime", "  hello-world/deployment:", "    artifact:\torg.acme:hello-world-deployment:1.0.0-SNAPSHOT", "    name:\tHello World - Deployment", "    package names: org.acme.hello.world.deployment, org.acme.hello.world.test", "  hello-world/integration-test:", "    artifact:\torg.acme:hello-world-integration-tests:1.0.0-SNAPSHOT", "    name:\tHello World - Integration Tests", "    package name: org.acme.hello.world.it", "  hello-world/docs:", "    artifact:\torg.acme:hello-world-docs:1.0.0-SNAPSHOT", "    name:\tHello World - Documentation", "%nGenerated classes will use 'HelloWorld' as a class name prefix."})
public class CreateExtension
extends BaseCreateCommand {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    @CommandLine.Mixin
    ExtensionGAVMixin gav = new ExtensionGAVMixin();
    @CommandLine.ArgGroup(order=1, heading="%nQuarkus version:%n")
    TargetQuarkusVersionGroup targetQuarkusVersion = new TargetQuarkusVersionGroup();
    @CommandLine.ArgGroup(order=2, exclusive=false, heading="%nGenerated artifacts%n")
    ExtensionNameGenerationGroup nameGeneration = new ExtensionNameGenerationGroup();
    @CommandLine.ArgGroup(order=3, exclusive=false, heading="%nCode Generation (Optional):%n")
    ExtensionCodeGenerationGroup codeGeneration = new ExtensionCodeGenerationGroup();
    @CommandLine.ArgGroup(order=4, exclusive=false, validate=false)
    PropertiesOptions propertiesOptions = new PropertiesOptions();

    @Override
    public Integer call() throws Exception {
        try {
            this.output.debug("Creating a new extension project with initial parameters: %s", new Object[]{this});
            this.output.throwIfUnmatchedArguments(this.spec.commandLine());
            this.setExtensionId(this.gav.getExtensionId());
            this.setTestOutputDirectory(this.output.getTestDirectory());
            if (this.checkProjectRootAlreadyExists(this.runMode.isDryRun())) {
                return 2;
            }
            BuildTool buildTool = BuildTool.MAVEN;
            QuarkusProject quarkusProject = this.getExtensionVersions(buildTool, this.targetQuarkusVersion);
            ExtensionCatalog catalog = quarkusProject.getExtensionsCatalog();
            ArtifactCoords quarkusBom = catalog.getBom();
            CreateExtensionCommandHandler createExtension = new io.quarkus.devtools.commands.CreateExtension(this.outputDirectory()).extensionId(this.gav.getExtensionId()).groupId(this.gav.getGroupId()).version(this.gav.getVersion()).extensionName(this.nameGeneration.getExtensionName()).extensionDescription(this.nameGeneration.extensionDescription()).namespaceId(this.nameGeneration.getNamespaceId()).namespaceName(this.nameGeneration.getNamespaceName()).packageName(this.nameGeneration.getPackageName()).quarkusVersion(catalog.getQuarkusCoreVersion()).quarkusBomGroupId(quarkusBom.getGroupId()).quarkusBomArtifactId(quarkusBom.getArtifactId()).quarkusBomVersion(quarkusBom.getVersion()).withCodestart(this.codeGeneration.withCodestart()).withoutUnitTest(this.codeGeneration.skipUnitTest()).withoutDevModeTest(this.codeGeneration.skipDevModeTest()).withoutIntegrationTests(this.codeGeneration.skipIntegrationTests()).prepare();
            QuarkusCommandOutcome outcome = QuarkusCommandOutcome.success();
            if (this.runMode.isDryRun()) {
                this.dryRun(buildTool, createExtension, this.output);
            } else {
                outcome = createExtension.execute((MessageWriter)this.output);
            }
            if (outcome.isSuccess()) {
                if (!this.runMode.isDryRun()) {
                    this.output.info("Navigate into this directory and get started: " + this.spec.root().qualifiedName() + " build");
                }
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            this.output.error("Extension creation failed, " + e.getMessage());
            return this.output.handleCommandException(e, "Unable to create extension: " + e.getMessage());
        }
    }

    public void dryRun(BuildTool buildTool, CreateExtensionCommandHandler invocation, OutputOptionMixin output) {
        CommandLine.Help help = this.spec.commandLine().getHelp();
        output.printText("\nA new extension would have been created in", "\t" + this.outputDirectory().toString(), "\nThe extension would have been created using the following settings:\n");
        TreeMap<String, Object> dryRunOutput = new TreeMap<String, Object>();
        for (Map.Entry entry : invocation.getData().entrySet()) {
            dryRunOutput.put(this.prettyName((String)entry.getKey()), entry.getValue().toString());
        }
        dryRunOutput.put("Extension Codestart", "" + this.codeGeneration.withCodestart());
        dryRunOutput.put("Skip Unit Test", "" + this.codeGeneration.skipUnitTest());
        dryRunOutput.put("Skip Dev-mode Test", "" + this.codeGeneration.skipDevModeTest());
        dryRunOutput.put("Skip Integration Test", "" + this.codeGeneration.skipIntegrationTests());
        output.info(help.createTextTable(dryRunOutput).toString());
    }

    @Override
    public String toString() {
        return "CreateExtension{gav=" + this.gav + ", quarkusVersion=" + this.targetQuarkusVersion + ", nameGeneration=" + this.nameGeneration + ", testGeneration=" + this.codeGeneration + "}";
    }
}

