/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import io.quarkus.cli.build.BaseBuildCommand;
import io.quarkus.cli.build.BuildSystemRunner;
import io.quarkus.cli.common.RunModeOption;
import io.quarkus.devtools.project.BuildTool;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="remove", aliases={"rm"}, header={"Remove extension(s) from this project."})
public class ProjectExtensionsRemove
extends BaseBuildCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    RunModeOption runMode;
    @CommandLine.Parameters(arity="1", paramLabel="EXTENSION", description={"Extension(s) to remove from this project."})
    Set<String> extensions;

    @Override
    public Integer call() {
        try {
            this.output.debug("Remove extensions with initial parameters: %s", new Object[]{this});
            this.output.throwIfUnmatchedArguments(this.spec.commandLine());
            BuildSystemRunner runner = this.getRunner();
            if (this.runMode.isDryRun()) {
                this.dryRunRemove(this.spec.commandLine().getHelp(), runner.getBuildTool());
                return 0;
            }
            return runner.removeExtension(this.runMode, this.extensions);
        }
        catch (Exception e) {
            return this.output.handleCommandException(e, "Unable to remove extension(s): " + e.getMessage());
        }
    }

    void dryRunRemove(CommandLine.Help help, BuildTool buildTool) {
        this.output.printText("\nRemove extensions to the current project in \n", "\t" + this.projectRoot().toString());
        TreeMap<String, String> dryRunOutput = new TreeMap<String, String>();
        dryRunOutput.put("Build tool", buildTool.name());
        dryRunOutput.put("Batch (non-interactive mode)", Boolean.toString(this.runMode.isBatchMode()));
        dryRunOutput.put("Extension(s) to remove", this.extensions.toString());
        this.output.info(help.createTextTable(dryRunOutput).toString());
    }

    public String toString() {
        return "ProjectExtensionRemove [extensions=" + this.extensions + "]";
    }
}

