/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.build;

import io.quarkus.cli.build.BuildSystemRunner;
import io.quarkus.cli.build.ExecuteUtil;
import io.quarkus.cli.common.BuildOptions;
import io.quarkus.cli.common.CategoryListFormatOptions;
import io.quarkus.cli.common.DebugOptions;
import io.quarkus.cli.common.DevOptions;
import io.quarkus.cli.common.ListFormatOptions;
import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.PropertiesOptions;
import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.registry.RegistryClientMixin;
import io.quarkus.devtools.project.BuildTool;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class JBangRunner
implements BuildSystemRunner {
    static final String[] windowsWrapper = new String[]{"jbang.cmd", "jbang.ps1"};
    static final String otherWrapper = "jbang";
    final OutputOptionMixin output;
    final RegistryClientMixin registryClient;
    final PropertiesOptions propertiesOptions;
    final Path projectRoot;
    String mainPath;

    public JBangRunner(OutputOptionMixin output, PropertiesOptions propertiesOptions, RegistryClientMixin registryClient, Path projectRoot) {
        this.output = output;
        this.registryClient = registryClient;
        this.projectRoot = projectRoot;
        this.propertiesOptions = propertiesOptions;
    }

    @Override
    public OutputOptionMixin getOutput() {
        return this.output;
    }

    @Override
    public BuildTool getBuildTool() {
        return BuildTool.JBANG;
    }

    @Override
    public Integer listExtensionCategories(RunModeOption runMode, CategoryListFormatOptions format) throws Exception {
        throw new UnsupportedOperationException("Not there yet. ;)");
    }

    @Override
    public Integer listExtensions(RunModeOption runMode, ListFormatOptions format, boolean installable, String searchPattern, String category) throws Exception {
        throw new UnsupportedOperationException("Not there yet. ;)");
    }

    @Override
    public Integer addExtension(RunModeOption runMode, Set<String> extensions) {
        throw new UnsupportedOperationException("Not there yet. ;)");
    }

    @Override
    public Integer removeExtension(RunModeOption runMode, Set<String> extensions) {
        throw new UnsupportedOperationException("Not there yet. ;)");
    }

    @Override
    public Integer info(boolean perModule) {
        throw new UnsupportedOperationException("Not there yet. ;)");
    }

    @Override
    public Integer update(boolean rectify, boolean recommendedState, boolean perModule) {
        throw new UnsupportedOperationException("Not there yet. ;)");
    }

    @Override
    public BuildSystemRunner.BuildCommandArgs prepareBuild(BuildOptions buildOptions, RunModeOption runMode, List<String> params) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        if (buildOptions.offline) {
            args.add("--offline");
        }
        if (this.output.isVerbose()) {
            args.add("--verbose");
        }
        if (buildOptions.buildNative) {
            args.add("--native");
        }
        if (buildOptions.clean) {
            args.add("--fresh");
        }
        args.add("build");
        args.addAll(this.flattenMappedProperties(this.propertiesOptions.properties));
        args.add(this.registryClient.getRegistryClientProperty());
        args.addAll(params);
        args.add(this.getMainPath());
        return this.prependExecutable(args);
    }

    @Override
    public List<Supplier<BuildSystemRunner.BuildCommandArgs>> prepareDevMode(DevOptions devOptions, DebugOptions debugOptions, List<String> params) {
        throw new UnsupportedOperationException("Not there yet. ;)");
    }

    @Override
    public Path getProjectRoot() {
        return this.projectRoot;
    }

    @Override
    public File getWrapper() {
        return ExecuteUtil.findWrapper(this.projectRoot, windowsWrapper, otherWrapper);
    }

    @Override
    public File getExecutable() {
        return ExecuteUtil.findExecutable(otherWrapper, "Unable to find the jbang executable, is it in your path?", this.output);
    }

    String getMainPath() {
        if (this.mainPath == null) {
            String[] names;
            File src = this.projectRoot.resolve("src").toFile();
            if (src.exists() && src.isDirectory() && (names = src.list()) != null && names.length > 0) {
                String first = null;
                for (String name : names) {
                    if (name.equalsIgnoreCase("main.java")) {
                        this.mainPath = this.fixPath(src.toPath().resolve(name));
                        return this.mainPath;
                    }
                    if (first != null || !name.endsWith(".java")) continue;
                    first = name;
                }
                if (first != null) {
                    this.mainPath = this.fixPath(src.toPath().resolve(first));
                    return this.mainPath;
                }
            }
            throw new IllegalStateException("Unable to find a source file for use with JBang");
        }
        return this.mainPath;
    }
}

