/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.create;

import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.devtools.commands.CreateProjectHelper;
import io.quarkus.devtools.commands.SourceType;
import io.quarkus.devtools.project.BuildTool;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import picocli.CommandLine;

public class TargetLanguageGroup {
    SourceType sourceType;
    @CommandLine.Option(names={"--java"}, description={"Target Java version.\n  Valid values: ${COMPLETION-CANDIDATES}"}, completionCandidates=VersionCandidates.class, defaultValue="<<detect java runtime version>>")
    String javaVersion = "<<detect java runtime version>>";
    @CommandLine.Option(names={"--kotlin"}, description={"Use Kotlin"})
    boolean kotlin = false;
    @CommandLine.Option(names={"--scala"}, description={"Use Scala"})
    boolean scala = false;

    public SourceType getSourceType(CommandLine.Model.CommandSpec spec, BuildTool buildTool, Set<String> extensions, OutputOptionMixin output) {
        if (this.kotlin && this.scala) {
            throw new CommandLine.ParameterException(spec.commandLine(), "Invalid source type. Projects can target either Kotlin (--kotlin) or Scala (--scala), not both.");
        }
        if (this.sourceType == null) {
            if (buildTool == null) {
                this.sourceType = SourceType.JAVA;
                if (this.kotlin || this.scala) {
                    output.warn("JBang only supports Java. Using Java as the target language.");
                }
            } else {
                this.sourceType = this.kotlin ? SourceType.KOTLIN : (this.scala ? SourceType.SCALA : SourceType.resolve(extensions));
            }
        }
        return this.sourceType;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String toString() {
        return "TargetLanguageGroup [java=" + this.javaVersion + ", kotlin=" + this.kotlin + ", scala=" + this.scala + ", sourceType=" + this.sourceType + "]";
    }

    static class VersionCandidates
    extends ArrayList<String> {
        VersionCandidates() {
            super(CreateProjectHelper.JAVA_VERSIONS_LTS.stream().map(String::valueOf).collect(Collectors.toList()));
        }
    }
}

