/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import io.quarkus.cli.Build;
import io.quarkus.cli.Completion;
import io.quarkus.cli.Create;
import io.quarkus.cli.Dev;
import io.quarkus.cli.ProjectExtensions;
import io.quarkus.cli.Registry;
import io.quarkus.cli.Version;
import io.quarkus.cli.common.HelpOption;
import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.PropertiesOptions;
import io.quarkus.runtime.QuarkusApplication;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import picocli.CommandLine;

@CommandLine.Command(name="quarkus", subcommands={Create.class, Build.class, Dev.class, ProjectExtensions.class, Registry.class, Version.class, Completion.class}, scope=CommandLine.ScopeType.INHERIT, sortOptions=false, showDefaultValues=true, versionProvider=Version.class, subcommandsRepeatable=false, mixinStandardHelpOptions=false, commandListHeading="%nCommands:%n", synopsisHeading="%nUsage: ", optionListHeading="Options:%n", headerHeading="%n", parameterListHeading="%n")
public class QuarkusCli
implements QuarkusApplication,
Callable<Integer> {
    @Inject
    CommandLine.IFactory factory;
    @CommandLine.Mixin
    protected HelpOption helpOption;
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true, description={"Print version information and exit."})
    public boolean showVersion;
    @CommandLine.Mixin(name="output")
    OutputOptionMixin output;
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    @CommandLine.ArgGroup(exclusive=false, validate=false)
    protected PropertiesOptions propertiesOptions = new PropertiesOptions();

    public int run(String ... args) throws Exception {
        CommandLine cmd = this.factory == null ? new CommandLine((Object)this) : new CommandLine((Object)this, this.factory);
        cmd.getHelpSectionMap().put("commandList", new SubCommandListRenderer());
        cmd.setParameterExceptionHandler((CommandLine.IParameterExceptionHandler)new ShortErrorMessageHandler());
        return cmd.execute(args);
    }

    @Override
    public Integer call() throws Exception {
        this.output.info("%n@|bold Quarkus CLI|@ version %s", new Object[]{Version.clientVersion()});
        this.output.info("");
        this.output.info("Create Quarkus projects with Maven, Gradle, or JBang.");
        this.output.info("Manage extensions and source registries.");
        this.output.info("");
        this.output.info("Create: @|bold quarkus create|@");
        this.output.info("@|italic Iterate|@: @|bold quarkus dev|@");
        this.output.info("Build and test: @|bold quarkus build|@");
        this.output.info("");
        this.output.info("Find more information at https://quarkus.io");
        this.output.info("If you have questions, check https://github.com/quarkusio/quarkus/discussions");
        this.spec.commandLine().usage(this.output.out());
        this.output.info("");
        this.output.info("Use \"quarkus <command> --help\" for more information about a given command.");
        return this.spec.exitCodeOnUsageHelp();
    }

    static {
        System.setProperty("picocli.endofoptions.description", "End of command line options.");
    }

    class SubCommandListRenderer
    implements CommandLine.IHelpSectionRenderer {
        SubCommandListRenderer() {
        }

        public String render(CommandLine.Help help) {
            CommandLine.Model.CommandSpec spec = help.commandSpec();
            if (spec.subcommands().isEmpty()) {
                return "";
            }
            CommandLine.Help.Column commands = new CommandLine.Help.Column(24, 2, CommandLine.Help.Column.Overflow.SPAN);
            CommandLine.Help.Column descriptions = new CommandLine.Help.Column(spec.usageMessage().width() - 24, 2, CommandLine.Help.Column.Overflow.WRAP);
            CommandLine.Help.TextTable textTable = CommandLine.Help.TextTable.forColumns((CommandLine.Help.ColorScheme)help.colorScheme(), (CommandLine.Help.Column[])new CommandLine.Help.Column[]{commands, descriptions});
            textTable.setAdjustLineBreaksForWideCJKCharacters(spec.usageMessage().adjustLineBreaksForWideCJKCharacters());
            this.addHierarchy(spec.subcommands().values(), textTable, "");
            return textTable.toString();
        }

        private void addHierarchy(Collection<CommandLine> collection, CommandLine.Help.TextTable textTable, String indent) {
            collection.stream().distinct().forEach(subcommand -> {
                String names = String.join((CharSequence)", ", subcommand.getCommandSpec().names());
                String description = this.description(subcommand.getCommandSpec().usageMessage());
                textTable.addRowValues(new String[]{indent + names, description});
                Map subcommands = subcommand.getSubcommands();
                if (!subcommands.isEmpty()) {
                    this.addHierarchy(subcommands.values(), textTable, indent + "  ");
                }
            });
        }

        private String description(CommandLine.Model.UsageMessageSpec usageMessage) {
            if (usageMessage.header().length > 0) {
                return usageMessage.header()[0];
            }
            if (usageMessage.description().length > 0) {
                return usageMessage.description()[0];
            }
            return "";
        }
    }

    class ShortErrorMessageHandler
    implements CommandLine.IParameterExceptionHandler {
        ShortErrorMessageHandler() {
        }

        public int handleParseException(CommandLine.ParameterException ex, String[] args) {
            CommandLine cmd = ex.getCommandLine();
            CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
            QuarkusCli.this.output.error(ex.getMessage());
            QuarkusCli.this.output.printStackTrace((Exception)ex);
            CommandLine.UnmatchedArgumentException.printSuggestions((CommandLine.ParameterException)ex, (PrintWriter)QuarkusCli.this.output.err());
            QuarkusCli.this.output.err().println(cmd.getHelp().fullSynopsis());
            if (spec.equals(spec.root())) {
                QuarkusCli.this.output.err().println(cmd.getHelp().commandList());
            }
            QuarkusCli.this.output.err().printf("See '%s --help' for more information.%n", spec.qualifiedName());
            QuarkusCli.this.output.err().flush();
            return cmd.getExitCodeExceptionMapper() != null ? cmd.getExitCodeExceptionMapper().getExitCode((Throwable)ex) : spec.exitCodeOnInvalidInput();
        }
    }
}

