/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.create;

import io.quarkus.devtools.commands.CreateExtension;
import picocli.CommandLine;

public class ExtensionGAVMixin {
    static final String DEFAULT_EXTENSION_ID = "custom";
    static final String DEFAULT_GAV = "io.quarkiverse.custom:custom:1.0.0-SNAPSHOT";
    String groupId = null;
    String extensionId = null;
    String version = "1.0.0-SNAPSHOT";
    @CommandLine.Parameters(arity="0..1", paramLabel="[GROUP-ID:]EXTENSION-ID[:VERSION]", description={"Quarkus extension project identifiers%n  io.quarkiverse.custom:custom:1.0.0-SNAPSHOT%n  Examples:%n     my-extension%n     my.group:my-extension%n     my.group:my-extension:0.1%n"})
    String gav = null;

    void projectGav() {
        if (this.extensionId == null) {
            if (this.gav != null) {
                int firstPos = this.gav.indexOf(":");
                int lastPos = this.gav.lastIndexOf(":");
                if (firstPos < 0) {
                    this.extensionId = this.gav;
                } else {
                    if (firstPos != 0) {
                        this.groupId = this.gav.substring(0, firstPos);
                    }
                    if (lastPos == firstPos) {
                        this.extensionId = this.gav.substring(firstPos + 1);
                    } else if (lastPos >= firstPos + 2) {
                        this.extensionId = this.gav.substring(firstPos + 1, lastPos);
                    }
                    if (lastPos > firstPos && lastPos <= this.gav.length() - 2) {
                        this.version = this.gav.substring(lastPos + 1);
                    }
                }
            }
            if (CreateExtension.isQuarkiverseGroupId((String)this.groupId) && this.extensionId == null) {
                this.extensionId = CreateExtension.extractQuarkiverseExtensionId((String)this.groupId);
            }
            if (this.extensionId == null || this.extensionId.isBlank()) {
                this.extensionId = DEFAULT_EXTENSION_ID;
            }
            if (this.groupId == null || this.groupId.isBlank()) {
                this.groupId = "io.quarkiverse." + this.extensionId;
            }
        }
    }

    public String getGroupId() {
        this.projectGav();
        return this.groupId;
    }

    public String getExtensionId() {
        this.projectGav();
        return this.extensionId;
    }

    public String getVersion() {
        this.projectGav();
        return this.version;
    }

    public String toString() {
        return "ExtensionTargetGVGroup [groupId=" + this.groupId + ", extensionId=" + this.extensionId + ", version=" + this.version + ", gav=" + this.gav + "]";
    }
}

