/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.config;

import io.quarkus.cli.config.BaseConfigCommand;
import io.quarkus.devtools.messagewriter.MessageIcons;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.Callable;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import picocli.CommandLine;

@CommandLine.Command(name="encrypt", aliases={"enc"}, header={"Encrypt Secrets"}, description={"Encrypt a Secret value using the AES/GCM/NoPadding algorithm as a default. The encryption key is generated unless a specific key is set with the --key option."})
public class Encrypt
extends BaseConfigCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", paramLabel="SECRET", description={"The Secret value to encrypt"})
    String secret;
    @CommandLine.Option(names={"-k", "--key"}, description={"The Encryption Key"})
    String encryptionKey;
    @CommandLine.Option(names={"-f", "--format"}, description={"The Encryption Key Format (base64 / plain)"}, defaultValue="base64")
    KeyFormat encryptionKeyFormat;
    @CommandLine.Option(hidden=true, names={"-a", "--algorithm"}, description={"Algorithm"}, defaultValue="AES")
    String algorithm;
    @CommandLine.Option(hidden=true, names={"-m", "--mode"}, description={"Mode"}, defaultValue="GCM")
    String mode;
    @CommandLine.Option(hidden=true, names={"-p", "--padding"}, description={"Padding"}, defaultValue="NoPadding")
    String padding;
    @CommandLine.Option(hidden=true, names={"-q", "--quiet"}, defaultValue="false")
    boolean quiet;
    private String encryptedSecret;

    @Override
    public Integer call() throws Exception {
        boolean generatedKey = false;
        if (this.encryptionKey == null) {
            this.encryptionKey = this.encodeToString(this.generateEncryptionKey().getEncoded());
            generatedKey = true;
        } else if (this.encryptionKeyFormat.equals((Object)KeyFormat.base64)) {
            this.encryptionKey = this.encodeToString(this.encryptionKey.getBytes());
        }
        Cipher cipher = Cipher.getInstance(this.algorithm + "/" + this.mode + "/" + this.padding);
        byte[] iv = new byte[12];
        new SecureRandom().nextBytes(iv);
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        sha256.update(this.encryptionKey.getBytes(StandardCharsets.UTF_8));
        cipher.init(1, (Key)new SecretKeySpec(sha256.digest(), "AES"), new GCMParameterSpec(128, iv));
        byte[] encrypted = cipher.doFinal(this.secret.getBytes(StandardCharsets.UTF_8));
        ByteBuffer message = ByteBuffer.allocate(1 + iv.length + encrypted.length);
        message.put((byte)iv.length);
        message.put(iv);
        message.put(encrypted);
        this.encryptedSecret = Base64.getUrlEncoder().withoutPadding().encodeToString(message.array());
        if (!this.quiet) {
            String success = MessageIcons.SUCCESS_ICON + " The secret @|bold " + this.secret + "|@ was encrypted to @|bold " + this.encryptedSecret + "|@";
            if (generatedKey) {
                success = success + " with the generated encryption key (" + this.encryptionKeyFormat + "): @|bold " + this.encryptionKey + "|@";
            }
            this.output.info(success);
        }
        return 0;
    }

    private SecretKey generateEncryptionKey() {
        try {
            return KeyGenerator.getInstance(this.algorithm).generateKey();
        }
        catch (Exception e) {
            this.output.error("Error while generating the encryption key: ");
            this.output.printStackTrace(e);
            System.exit(-1);
            return null;
        }
    }

    public String getEncryptedSecret() {
        return this.encryptedSecret;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public static enum KeyFormat {
        base64,
        plain;

    }
}

