/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.config;

import io.quarkus.cli.config.BaseConfigCommand;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.smallrye.config.ConfigValue;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="remove", header={"Removes a configuration from application.properties"})
public class RemoveConfig
extends BaseConfigCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", arity="1", paramLabel="NAME", description={"Configuration name"})
    String name;

    @Override
    public Integer call() throws Exception {
        Path properties = this.projectRoot().resolve("src/main/resources/application.properties");
        if (!properties.toFile().exists()) {
            this.output.error("Could not find an application.properties file");
            return -1;
        }
        List<String> lines = Files.readAllLines(properties);
        ConfigValue configValue = this.findKey(lines, this.name);
        if (configValue.getLineNumber() == -1) {
            this.output.error("Could not find configuration " + this.name);
            return -1;
        }
        this.output.info(MessageIcons.SUCCESS_ICON + " Removing configuration @|bold " + this.name + "|@");
        lines.remove(configValue.getLineNumber());
        try (BufferedWriter writer = Files.newBufferedWriter(properties, new OpenOption[0]);){
            for (String i : lines) {
                writer.write(i);
                writer.newLine();
            }
        }
        return 0;
    }
}

