/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.config;

import io.quarkus.cli.config.BaseConfigCommand;
import io.quarkus.cli.config.Encrypt;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="set", header={"Sets a configuration in application.properties"})
public class SetConfig
extends BaseConfigCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", arity="1", paramLabel="NAME", description={"Configuration name"})
    String name;
    @CommandLine.Parameters(index="1", arity="0..1", paramLabel="VALUE", description={"Configuration value"})
    String value;
    @CommandLine.Option(names={"-k", "--encrypt"}, description={"Encrypt the configuration value"})
    boolean encrypt;

    @Override
    public Integer call() throws Exception {
        String actualValue;
        Path properties = this.projectRoot().resolve("src/main/resources/application.properties");
        if (!properties.toFile().exists()) {
            this.output.warn("Could not find an application.properties file, creating one now!");
            Path resources = this.projectRoot().resolve("src/main/resources");
            Files.createDirectories(resources, new FileAttribute[0]);
            Files.createFile(resources.resolve("application.properties"), new FileAttribute[0]);
            this.output.info(MessageIcons.SUCCESS_ICON + " @|bold application.properties|@ file created in @|bold src/main/resources|@");
        }
        List<String> lines = Files.readAllLines(properties);
        if (this.encrypt) {
            int execute;
            ConfigValue encryptionDecode;
            Encrypt encrypt = new Encrypt();
            ArrayList<Object> args = new ArrayList<Object>();
            args.add("-q");
            if (this.value == null) {
                this.value = this.findKey(lines, this.name).getValue();
            }
            args.add(this.value);
            if (this.value == null || this.value.length() == 0) {
                this.output.error("Cannot encrypt an empty value");
                return -1;
            }
            ConfigValue encryptionKey = this.findKey(lines, "smallrye.config.secret-handler.aes-gcm-nopadding.encryption-key");
            if (encryptionKey.getValue() != null) {
                args.add("--key=" + encryptionKey.getValue());
            }
            if ((encryptionDecode = this.findKey(lines, "smallrye.config.secret-handler.aes-gcm-nopadding.encryption-key-decode")).getValue() == null || !((Boolean)Converters.getImplicitConverter(Boolean.class).convert(encryptionDecode.getValue())).booleanValue()) {
                args.add("--format=plain");
            }
            if ((execute = new CommandLine((Object)encrypt).execute(args.toArray(new String[0]))) < 0) {
                System.exit(execute);
            }
            this.value = "${aes-gcm-nopadding::" + encrypt.getEncryptedSecret() + "}";
            if (encryptionKey.getValue() == null) {
                lines.add(encryptionKey.getName() + "=" + encrypt.getEncryptionKey());
            }
        }
        ConfigValue configValue = this.findKey(lines, this.name);
        String string = actualValue = this.value != null ? this.value : "empty value";
        if (configValue.getLineNumber() != -1) {
            this.output.info(MessageIcons.SUCCESS_ICON + " Setting configuration @|bold " + this.name + "|@ to value @|bold " + actualValue + "|@");
            lines.set(configValue.getLineNumber(), this.name + "=" + (this.value != null ? this.value : ""));
        } else {
            this.output.info(MessageIcons.SUCCESS_ICON + " Adding configuration @|bold " + this.name + "|@ with value @|bold " + actualValue + "|@");
            lines.add(this.name + "=" + (this.value != null ? this.value : ""));
        }
        try (BufferedWriter writer = Files.newBufferedWriter(properties, new OpenOption[0]);){
            for (String i : lines) {
                writer.write(i);
                writer.newLine();
            }
        }
        return 0;
    }
}

