/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.plugin.CliPluginsBase;
import io.quarkus.cli.plugin.Plugin;
import io.quarkus.cli.plugin.PluginListItem;
import io.quarkus.cli.plugin.PluginListTable;
import io.quarkus.cli.plugin.PluginManager;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.utils.Patterns;
import io.quarkus.runtime.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, header={"List CLI plugins. "})
public class CliPluginsList
extends CliPluginsBase
implements Callable<Integer> {
    @CommandLine.Mixin
    RunModeOption runMode;
    @CommandLine.Option(names={"-i", "--installable"}, defaultValue="false", order=4, description={"List plugins that can be installed"})
    boolean installable = false;
    @CommandLine.Option(names={"-s", "--search"}, defaultValue="*", order=5, paramLabel="PATTERN", description={"Search for matching plugins (simple glob using '*' and '?')."})
    String searchPattern;
    @CommandLine.Option(names={"-c", "--show-command"}, defaultValue="false", order=6, description={"Show the command that corresponds to the plugin"})
    boolean showCommand = false;
    Map<String, Plugin> installedPlugins = new HashMap<String, Plugin>();

    @Override
    public Integer call() {
        try {
            this.output.debug("List extensions with initial parameters: %s", new Object[]{this});
            this.output.throwIfUnmatchedArguments(this.spec.commandLine());
            if (this.runMode.isDryRun()) {
                return this.dryRunList(this.spec.commandLine().getHelp(), null);
            }
            Integer exitCode = this.listPluigns();
            this.printHints(!this.installable && this.installedPlugins.isEmpty(), this.installable);
            return exitCode;
        }
        catch (Exception e) {
            return this.output.handleCommandException(e, "Unable to list plugins: " + e.getMessage());
        }
    }

    Integer dryRunList(CommandLine.Help help, BuildTool buildTool) {
        TreeMap<String, String> dryRunOutput = new TreeMap<String, String>();
        this.output.printText("\nList plugins\n");
        dryRunOutput.put("Search pattern", this.searchPattern);
        dryRunOutput.put("List installable", String.valueOf(this.installable));
        dryRunOutput.put("Type", String.valueOf(this.type));
        dryRunOutput.put("Only user", String.valueOf(this.catalogOptions.user));
        this.output.info(help.createTextTable(dryRunOutput).toString());
        return 0;
    }

    Integer listPluigns() {
        PluginManager pluginManager = this.pluginManager();
        Predicate<Plugin> pluginFilter = this.pluginFilter();
        pluginManager.reconcile();
        this.installedPlugins.putAll(pluginManager.getInstalledPlugins(this.catalogOptions.user));
        HashMap<String, PluginListItem> items = new HashMap<String, PluginListItem>();
        if (this.installable) {
            Map availablePlugins = pluginManager.getInstallablePlugins();
            items.putAll(availablePlugins.values().stream().filter((? super T p) -> !this.installedPlugins.containsKey(p.getName())).filter(pluginFilter).map(p -> new PluginListItem(this.installedPlugins.containsKey(p.getName()), (Plugin)p)).collect(Collectors.toMap(p -> p.getName(), p -> p)));
        }
        items.putAll(this.installedPlugins.entrySet().stream().filter((? super T e) -> pluginFilter.test((Plugin)e.getValue())).map(e -> new PluginListItem(true, (Plugin)e.getValue())).collect(Collectors.toMap(p -> p.getName(), p -> p)));
        if (items.isEmpty()) {
            this.output.info("No plugins " + (this.installable ? "installable" : "installed") + "!");
        } else {
            PluginListTable table = new PluginListTable(items.values().stream().filter(this::filter).collect(Collectors.toList()), this.showCommand);
            this.output.info(table.getContent());
        }
        return 0;
    }

    private void printHints(boolean installableHint, boolean remoteHint) {
        if (this.runMode.isBatchMode()) {
            return;
        }
        if (installableHint) {
            this.output.info("To include the installable plugins in the list, append --installable to the command.");
        }
        if (remoteHint) {
            this.output.info("Use the 'plugin add' subcommand and pass the location of any plugin listed above, or any remote location in the form of URL / GACTV pointing to a remote plugin.");
        }
    }

    private boolean filter(PluginListItem item) {
        if (StringUtil.isNullOrEmpty((String)this.searchPattern)) {
            return true;
        }
        if (!Patterns.isExpression((String)this.searchPattern)) {
            return item.getName().contains(this.searchPattern);
        }
        Pattern p = Patterns.toRegex((String)this.searchPattern);
        return p.matcher(item.getName()).matches();
    }

    public String toString() {
        return "CliPluginsList [, output=" + this.output + ", runMode=" + this.runMode + "]";
    }
}

