/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.consul.config.runtime;

import io.quarkus.consul.config.runtime.ValueType;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(name="consul-config", phase=ConfigPhase.BOOTSTRAP)
public class ConsulConfig {
    @ConfigItem(defaultValue="false")
    boolean enabled;
    @ConfigItem
    AgentConfig agent;
    @ConfigItem
    Optional<String> prefix;
    @ConfigItem
    Optional<List<String>> rawValueKeys;
    @ConfigItem
    Optional<List<String>> propertiesValueKeys;
    @ConfigItem(defaultValue="true")
    boolean failOnMissingKey;

    Map<String, ValueType> keysAsMap() {
        LinkedHashMap<String, ValueType> result = new LinkedHashMap<String, ValueType>();
        if (this.rawValueKeys.isPresent()) {
            for (String key : this.rawValueKeys.get()) {
                result.put(key, ValueType.RAW);
            }
        }
        if (this.propertiesValueKeys.isPresent()) {
            for (String key : this.propertiesValueKeys.get()) {
                result.put(key, ValueType.PROPERTIES);
            }
        }
        return result;
    }

    @ConfigGroup
    public static class AgentConfig {
        @ConfigItem(defaultValue="localhost:8500")
        InetSocketAddress hostPort;
        @ConfigItem(defaultValue="false")
        boolean useHttps;
        @ConfigItem
        Optional<String> token;
        @ConfigItem
        public Optional<Path> trustStore;
        @ConfigItem
        public Optional<String> trustStorePassword;
        @ConfigItem
        public Optional<Path> keyStore;
        @ConfigItem
        public Optional<String> keyStorePassword;
        @ConfigItem
        public Optional<String> keyPassword;
        @ConfigItem(defaultValue="false")
        boolean trustCerts;
        @ConfigItem(defaultValue="10S")
        public Duration connectionTimeout;
        @ConfigItem(defaultValue="60S")
        public Duration readTimeout;
    }
}

