/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.consul.config.runtime;

import io.quarkus.consul.config.runtime.ConsulConfig;
import io.quarkus.consul.config.runtime.ConsulConfigSourceProvider;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Collections;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

@Recorder
public class ConsulConfigRecorder {
    private static final Logger log = Logger.getLogger(ConsulConfigRecorder.class);

    public RuntimeValue<ConfigSourceProvider> configSources(ConsulConfig consulConfig) {
        if (!consulConfig.enabled) {
            log.debug((Object)"No attempt will be made to obtain configuration from Consul because the functionality has been disabled via configuration");
            return this.emptyRuntimeValue();
        }
        return new RuntimeValue((Object)new ConsulConfigSourceProvider(consulConfig));
    }

    private RuntimeValue<ConfigSourceProvider> emptyRuntimeValue() {
        return new RuntimeValue((Object)new EmptyConfigSourceProvider());
    }

    private static class EmptyConfigSourceProvider
    implements ConfigSourceProvider {
        private EmptyConfigSourceProvider() {
        }

        public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
            return Collections.emptyList();
        }
    }
}

