/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.consul.config.runtime;

import io.quarkus.consul.config.runtime.ConsulConfig;
import io.quarkus.consul.config.runtime.ConsulConfigGateway;
import io.quarkus.consul.config.runtime.DefaultConsulConfigGateway;
import io.quarkus.consul.config.runtime.Response;
import io.quarkus.consul.config.runtime.ResponseConfigSourceUtil;
import io.quarkus.consul.config.runtime.ValueType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

class ConsulConfigSourceProvider
implements ConfigSourceProvider {
    private static final Logger log = Logger.getLogger(ConsulConfigSourceProvider.class);
    private final ConsulConfig config;
    private final ConsulConfigGateway consulConfigGateway;
    private final ResponseConfigSourceUtil responseConfigSourceUtil;

    public ConsulConfigSourceProvider(ConsulConfig config) {
        this(config, new DefaultConsulConfigGateway(config), new ResponseConfigSourceUtil());
    }

    ConsulConfigSourceProvider(ConsulConfig config, ConsulConfigGateway consulConfigGateway) {
        this(config, consulConfigGateway, new ResponseConfigSourceUtil());
    }

    private ConsulConfigSourceProvider(ConsulConfig config, ConsulConfigGateway consulConfigGateway, ResponseConfigSourceUtil responseConfigSourceUtil) {
        this.config = config;
        this.consulConfigGateway = consulConfigGateway;
        this.responseConfigSourceUtil = responseConfigSourceUtil;
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader cl) {
        Map<String, ValueType> keys = this.config.keysAsMap();
        if (keys.isEmpty()) {
            log.debug((Object)"No keys were configured for config source lookup");
            return Collections.emptyList();
        }
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>(keys.size());
        for (Map.Entry<String, ValueType> entry : keys.entrySet()) {
            String fullKey = this.config.prefix.isPresent() ? this.config.prefix.get() + "/" + entry.getKey() : entry.getKey();
            log.debug((Object)("Attempting to look up value of key '" + fullKey + "' from Consul."));
            try {
                Optional<Response> optionalResponse = this.consulConfigGateway.getValue(fullKey);
                if (optionalResponse.isPresent()) {
                    result.add(this.responseConfigSourceUtil.toConfigSource(optionalResponse.get(), entry.getValue(), this.config.prefix));
                } else {
                    String message = "Key '" + fullKey + "' not found in Consul.";
                    if (this.config.failOnMissingKey) {
                        throw new RuntimeException(message);
                    }
                    log.info((Object)message);
                }
                log.debug((Object)("Done reading value of key '" + fullKey + "'"));
            }
            catch (IOException e) {
                throw new UncheckedIOException("An error occurred while attempting to fetch configuration from Consul.", e);
            }
        }
        return result;
    }
}

