/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.consul.config.runtime;

import io.quarkus.consul.config.runtime.ConsulConfig;
import io.quarkus.consul.config.runtime.ConsulConfigGateway;
import io.quarkus.consul.config.runtime.Response;
import io.quarkus.consul.config.runtime.ResponseConfigSourceUtil;
import io.quarkus.consul.config.runtime.ValueType;
import io.quarkus.consul.config.runtime.VertxConsulConfigGateway;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniAwait;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

class ConsulConfigSourceProvider
implements ConfigSourceProvider {
    private static final Logger log = Logger.getLogger(ConsulConfigSourceProvider.class);
    private final ConsulConfig config;
    private final ConsulConfigGateway consulConfigGateway;
    private final ResponseConfigSourceUtil responseConfigSourceUtil;

    public ConsulConfigSourceProvider(ConsulConfig config) {
        this(config, new VertxConsulConfigGateway(config), new ResponseConfigSourceUtil());
    }

    ConsulConfigSourceProvider(ConsulConfig config, ConsulConfigGateway consulConfigGateway) {
        this(config, consulConfigGateway, new ResponseConfigSourceUtil());
    }

    private ConsulConfigSourceProvider(ConsulConfig config, ConsulConfigGateway consulConfigGateway, ResponseConfigSourceUtil responseConfigSourceUtil) {
        this.config = config;
        this.consulConfigGateway = consulConfigGateway;
        this.responseConfigSourceUtil = responseConfigSourceUtil;
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader cl) {
        Map<String, ValueType> keys = this.config.keysAsMap();
        if (keys.isEmpty()) {
            log.debug((Object)"No keys were configured for config source lookup");
            return Collections.emptyList();
        }
        final ArrayList<ConfigSource> result = new ArrayList<ConfigSource>(keys.size());
        ArrayList<Uni> allUnis = new ArrayList<Uni>();
        for (final Map.Entry<String, ValueType> entry : keys.entrySet()) {
            final String fullKey = this.config.prefix.isPresent() ? this.config.prefix.get() + "/" + entry.getKey() : entry.getKey();
            allUnis.add(this.consulConfigGateway.getValue(fullKey).invoke((Consumer)new Consumer<Response>(){

                @Override
                public void accept(Response response) {
                    if (response != null) {
                        result.add(ConsulConfigSourceProvider.this.responseConfigSourceUtil.toConfigSource(response, (ValueType)((Object)entry.getValue()), ConsulConfigSourceProvider.this.config.prefix));
                    } else {
                        String message = "Key '" + fullKey + "' not found in Consul.";
                        if (ConsulConfigSourceProvider.this.config.failOnMissingKey) {
                            throw new RuntimeException(message);
                        }
                        log.info((Object)message);
                    }
                }
            }));
        }
        try {
            UniAwait await = Uni.combine().all().unis(allUnis).discardItems().await();
            if (this.config.agent.connectionTimeout.isZero() && this.config.agent.readTimeout.isZero()) {
                await.indefinitely();
            } else {
                await.atMost(this.config.agent.connectionTimeout.plus(this.config.agent.readTimeout.multipliedBy(2L)));
            }
        }
        catch (CompletionException e) {
            throw new RuntimeException("An error occurred while attempting to fetch configuration from Consul.", e);
        }
        finally {
            this.consulConfigGateway.close();
        }
        return result;
    }
}

